/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ProxyRequestBody;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneProxyRequestRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private ProxyRequestBody proxyRequestBody;

    @JsonCreator
    public StackoneProxyRequestRequest(String xAccountId, Optional<String> prefer, ProxyRequestBody proxyRequestBody) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.proxyRequestBody = proxyRequestBody;
    }

    public StackoneProxyRequestRequest(String xAccountId, ProxyRequestBody proxyRequestBody) {
        this(xAccountId, Optional.empty(), proxyRequestBody);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public ProxyRequestBody proxyRequestBody() {
        return this.proxyRequestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneProxyRequestRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public StackoneProxyRequestRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public StackoneProxyRequestRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public StackoneProxyRequestRequest withProxyRequestBody(ProxyRequestBody proxyRequestBody) {
        Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
        this.proxyRequestBody = proxyRequestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneProxyRequestRequest other = (StackoneProxyRequestRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.proxyRequestBody, other.proxyRequestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.proxyRequestBody);
    }

    public String toString() {
        return Utils.toString(StackoneProxyRequestRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "proxyRequestBody", this.proxyRequestBody);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private ProxyRequestBody proxyRequestBody;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder proxyRequestBody(ProxyRequestBody proxyRequestBody) {
            Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
            this.proxyRequestBody = proxyRequestBody;
            return this;
        }

        public StackoneProxyRequestRequest build() {
            return new StackoneProxyRequestRequest(this.xAccountId, this.prefer, this.proxyRequestBody);
        }
    }
}

