/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.SpeakeasyLogger;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class Hooks
implements Hook.BeforeRequest,
Hook.AfterSuccess,
Hook.AfterError,
Hook.SdkInit {
    private static final SpeakeasyLogger logger = SpeakeasyLogger.getLogger(Hooks.class);
    private final List<Hook.BeforeRequest> beforeRequestHooks = new CopyOnWriteArrayList<Hook.BeforeRequest>();
    private final List<Hook.AfterSuccess> afterSuccessHooks = new CopyOnWriteArrayList<Hook.AfterSuccess>();
    private final List<Hook.AfterError> afterErrorHooks = new CopyOnWriteArrayList<Hook.AfterError>();
    private final List<Hook.SdkInit> SdkInitHooks = new CopyOnWriteArrayList<Hook.SdkInit>();

    public Hooks registerBeforeRequest(Hook.BeforeRequest beforeRequest) {
        Utils.checkNotNull(beforeRequest, "beforeRequest");
        this.beforeRequestHooks.add(beforeRequest);
        logger.debug("Registered BeforeRequest hook: {} (total: {})", (Object)beforeRequest.getClass().getSimpleName(), (Object)this.beforeRequestHooks.size());
        return this;
    }

    public Hooks registerAfterSuccess(Hook.AfterSuccess afterSuccess) {
        Utils.checkNotNull(afterSuccess, "afterSuccess");
        this.afterSuccessHooks.add(afterSuccess);
        logger.debug("Registered AfterSuccess hook: {} (total: {})", (Object)afterSuccess.getClass().getSimpleName(), (Object)this.afterSuccessHooks.size());
        return this;
    }

    public Hooks registerAfterError(Hook.AfterError afterError) {
        Utils.checkNotNull(afterError, "afterError");
        this.afterErrorHooks.add(afterError);
        logger.debug("Registered AfterError hook: {} (total: {})", (Object)afterError.getClass().getSimpleName(), (Object)this.afterErrorHooks.size());
        return this;
    }

    public Hooks registerSdkInit(Hook.SdkInit SdkInit2) {
        Utils.checkNotNull(SdkInit2, "SdkInit");
        this.SdkInitHooks.add(SdkInit2);
        logger.debug("Registered SdkInit hook: {} (total: {})", (Object)SdkInit2.getClass().getSimpleName(), (Object)this.SdkInitHooks.size());
        return this;
    }

    @Override
    public HttpRequest beforeRequest(Hook.BeforeRequestContext context, HttpRequest request) throws Exception {
        Utils.checkNotNull(context, "context");
        Utils.checkNotNull(request, "request");
        if (logger.isTraceEnabled() && !this.beforeRequestHooks.isEmpty()) {
            logger.trace("Executing {} beforeRequest hook(s) for operation: {}", (Object)this.beforeRequestHooks.size(), (Object)context.operationId());
        }
        for (Hook.BeforeRequest hook : this.beforeRequestHooks) {
            request = hook.beforeRequest(context, request);
        }
        return request;
    }

    @Override
    public HttpResponse<InputStream> afterSuccess(Hook.AfterSuccessContext context, HttpResponse<InputStream> response) throws Exception {
        Utils.checkNotNull(context, "context");
        Utils.checkNotNull(response, "response");
        if (logger.isTraceEnabled() && !this.afterSuccessHooks.isEmpty()) {
            logger.trace("Executing {} afterSuccess hook(s) for operation: {}", (Object)this.afterSuccessHooks.size(), (Object)context.operationId());
        }
        for (Hook.AfterSuccess hook : this.afterSuccessHooks) {
            response = hook.afterSuccess(context, response);
            if (response != null) continue;
            throw new IllegalStateException("afterSuccess cannot return null");
        }
        return response;
    }

    @Override
    public HttpResponse<InputStream> afterError(Hook.AfterErrorContext context, Optional<HttpResponse<InputStream>> response, Optional<Exception> error) throws Exception {
        Utils.checkNotNull(context, "context");
        Utils.checkNotNull(response, "response");
        Utils.checkNotNull(error, "error");
        Utils.checkArgument(response.isPresent() ^ error.isPresent(), "one and only one of response or error must be present");
        if (logger.isTraceEnabled() && !this.afterErrorHooks.isEmpty()) {
            logger.trace("Executing {} afterError hook(s) for operation: {}", (Object)this.afterErrorHooks.size(), (Object)context.operationId());
        }
        for (Hook.AfterError hook : this.afterErrorHooks) {
            try {
                if ((response = Optional.ofNullable(hook.afterError(context, response, error))).isPresent()) continue;
                throw new IllegalStateException("afterError must either throw an exception or return a non-null response");
            }
            catch (FailEarlyException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw (Error)cause;
            }
            catch (Exception e) {
                logger.debug("Hook threw exception: {}", (Object)e.getClass().getSimpleName());
                error = Optional.of(e);
                response = Optional.empty();
            }
        }
        if (response.isPresent()) {
            return response.get();
        }
        throw error.get();
    }

    @Override
    public Hook.SdkInitData sdkInit(Hook.SdkInitData data) {
        Utils.checkNotNull(data, "data");
        if (logger.isDebugEnabled() && !this.SdkInitHooks.isEmpty()) {
            logger.debug("Executing {} sdkInit hook(s)", (Object)this.SdkInitHooks.size());
        }
        for (Hook.SdkInit hook : this.SdkInitHooks) {
            data = hook.sdkInit(data);
            if (data != null) continue;
            throw new IllegalStateException("sdkInit cannot return null");
        }
        return data;
    }

    public static final class FailEarlyException
    extends RuntimeException {
        public FailEarlyException(Exception e) {
            super(e);
        }
    }
}

