/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.stackone.stackone_client_java.utils.BigDecimalString;
import com.stackone.stackone_client_java.utils.BigIntegerString;
import com.stackone.stackone_client_java.utils.JSON;
import com.stackone.stackone_client_java.utils.Reflections;
import com.stackone.stackone_client_java.utils.TypedObject;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openapitools.jackson.nullable.JsonNullable;

public class OneOfDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = -1L;
    private final transient List<Utils.TypeReferenceWithShape> typeReferences;
    private final Class<T> cls;
    private final ObjectMapper mapper;
    private static final Set<String> NUMERIC_CLASSES = Set.of(Integer.class.getCanonicalName(), Long.class.getCanonicalName(), BigInteger.class.getCanonicalName(), Float.class.getCanonicalName(), Double.class.getCanonicalName(), BigDecimal.class.getCanonicalName());
    private static final Set<String> DECIMAL_CLASSES = Set.of(Float.class.getCanonicalName(), Double.class.getCanonicalName(), BigDecimal.class.getCanonicalName());
    private static final Set<String> INTEGER_CLASSES = Set.of(Integer.class.getCanonicalName(), Long.class.getCanonicalName(), BigInteger.class.getCanonicalName());
    private static final Set<String> DATE_TIME_CLASSES = Set.of(OffsetDateTime.class.getCanonicalName(), LocalDate.class.getCanonicalName());

    protected OneOfDeserializer(Class<T> cls, boolean strict, Utils.TypeReferenceWithShape ... typeReferences) {
        super(cls);
        this.typeReferences = Arrays.asList(typeReferences);
        this.cls = cls;
        this.mapper = JSON.getMapper();
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        TreeNode tree = p.getCodec().readTree(p);
        return OneOfDeserializer.deserializeOneOf(this.mapper, tree, this.typeReferences, this.cls);
    }

    private static <T> T deserializeOneOf(ObjectMapper mapper, TreeNode tree, List<Utils.TypeReferenceWithShape> typeReferences, Class<T> cls) throws JsonProcessingException {
        String json = mapper.writeValueAsString((Object)tree);
        List<Match<T>> matches = new ArrayList<Match<T>>();
        for (Utils.TypeReferenceWithShape c : typeReferences) {
            try {
                JavaType jt = Utils.convertToShape(mapper.getTypeFactory(), c.typeReference(), c.shape());
                if (!OneOfDeserializer.matchPossible(jt, json)) continue;
                Object o = mapper.readValue(json, jt);
                o = Utils.convertToShapeInverse(o, c.shape(), jt);
                TypedObject typed = TypedObject.of(o, c.shape(), c.typeReference());
                T v = OneOfDeserializer.newInstance(cls, typed);
                matches.add(new Match<T>(c, v, tree));
            }
            catch (DatabindException databindException) {}
        }
        if (matches.size() == 1) {
            return ((Match)matches.get((int)0)).value;
        }
        if (!(matches = OneOfDeserializer.applyMatchPreferences(matches, json)).isEmpty()) {
            return matches.get((int)0).value;
        }
        JsonNode node = tree instanceof JsonNode ? (JsonNode)tree : mapper.readTree(json);
        TypedObject typed = TypedObject.of(node, Utils.JsonShape.DEFAULT, new TypeReference<JsonNode>(){});
        return OneOfDeserializer.newInstance(cls, typed);
    }

    private static Object unwrapValue(Object wrapper) {
        if (wrapper == null) {
            return null;
        }
        try {
            for (Field field : wrapper.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(JsonValue.class)) continue;
                field.setAccessible(true);
                Object fieldValue = field.get(wrapper);
                if (fieldValue instanceof TypedObject) {
                    return ((TypedObject)fieldValue).value();
                }
                return fieldValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wrapper;
    }

    private static boolean isJsonNullable(Object obj) {
        return obj instanceof JsonNullable;
    }

    private static Object unwrapJsonNullable(Object obj) {
        if (!(obj instanceof JsonNullable)) {
            return null;
        }
        JsonNullable nullable = (JsonNullable)obj;
        return nullable.isPresent() ? nullable.get() : null;
    }

    private static boolean isPrimitiveOrString(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz.isPrimitive() || clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Boolean.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == OffsetDateTime.class || clazz == LocalDate.class;
    }

    public static boolean matchPossible(JavaType type, String json) {
        if (OneOfDeserializer.typeIs(type, String.class) || OneOfDeserializer.typeIs(type, BigIntegerString.class) || OneOfDeserializer.typeIs(type, BigDecimalString.class)) {
            return OneOfDeserializer.isDoubleQuoted(json);
        }
        if (OneOfDeserializer.typeIs(type, Boolean.class)) {
            return json.equals("true") || json.equals("false");
        }
        if (NUMERIC_CLASSES.contains(type.getTypeName())) {
            return !json.contains("\"");
        }
        if (OneOfDeserializer.typeIs(type, OffsetDateTime.class) || OneOfDeserializer.typeIs(type, LocalDate.class)) {
            return OneOfDeserializer.isDoubleQuoted(json) && !OneOfDeserializer.isNumeric(json.substring(1, json.length() - 1));
        }
        return true;
    }

    private static boolean isDoubleQuoted(String s) {
        return s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"");
    }

    public static <T> List<Match<T>> applyMatchPreferences(List<Match<T>> matches, String json) {
        if (matches.size() <= 1) {
            return matches;
        }
        if (OneOfDeserializer.allNumeric(matches)) {
            List<Match<T>> decimalMatches = OneOfDeserializer.decimalMatches(matches);
            List<Match<T>> integerMatches = OneOfDeserializer.integerMatches(matches);
            matches = !decimalMatches.isEmpty() && !integerMatches.isEmpty() ? (json.contains("e") || json.contains(".") ? decimalMatches : integerMatches) : (!decimalMatches.isEmpty() ? decimalMatches : integerMatches);
        } else if (OneOfDeserializer.allDateTime(matches)) {
            List<Match<T>> list = matches = json.contains("T") ? OneOfDeserializer.filter(matches, OffsetDateTime.class) : OneOfDeserializer.filter(matches, LocalDate.class);
        }
        if (matches.size() > 1) {
            for (Match<T> match : matches) {
                match.countFields();
            }
            return matches.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        }
        return matches;
    }

    private static <T> List<Match<T>> filter(List<Match<T>> matches, Class<?> filterByClass) {
        return matches.stream().filter(x -> x.typeReference.typeReference().getType().getTypeName().equals(filterByClass.getCanonicalName())).collect(Collectors.toList());
    }

    private static <T> boolean allDateTime(List<Match<T>> matches) {
        return matches.stream().allMatch(x -> DATE_TIME_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName()));
    }

    private static <T> boolean allNumeric(List<Match<T>> matches) {
        return matches.stream().allMatch(x -> NUMERIC_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName()));
    }

    private static <T> List<Match<T>> decimalMatches(List<Match<T>> matches) {
        return matches.stream().filter(x -> DECIMAL_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName())).collect(Collectors.toList());
    }

    private static <T> List<Match<T>> integerMatches(List<Match<T>> matches) {
        return matches.stream().filter(x -> INTEGER_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName())).collect(Collectors.toList());
    }

    private static boolean isNumeric(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean typeIs(JavaType type, Class<?> cls) {
        return type.getRawClass().equals(cls);
    }

    private static <T> String typeNames(List<Match<T>> matches) {
        return "[" + matches.stream().map(x -> x.typeReference.typeReference().getType().getTypeName()).collect(Collectors.joining(", ")) + "]";
    }

    private static String typeReferenceNames(List<Utils.TypeReferenceWithShape> list) {
        return "[" + list.stream().map(x -> x.typeReference().getType().getTypeName()).collect(Collectors.joining(", ")) + "]";
    }

    private static <T> T newInstance(Class<T> cls, Object parameter) {
        try {
            Constructor<T> con = cls.getDeclaredConstructor(TypedObject.class);
            con.setAccessible(true);
            return con.newInstance(parameter);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class Match<T>
    implements Comparable<Match<T>> {
        final Utils.TypeReferenceWithShape typeReference;
        final T value;
        private final TreeNode tree;
        private int matched = 0;
        private int inexact = 0;
        private int unmatched = 0;

        Match(Utils.TypeReferenceWithShape typeReference, T value, TreeNode tree) {
            this.typeReference = typeReference;
            this.value = value;
            this.tree = tree;
        }

        private void countFields() {
            try {
                JsonNode jsonNode;
                Object unwrapped = OneOfDeserializer.unwrapValue(this.value);
                JsonNode jsonNode2 = jsonNode = this.tree instanceof JsonNode ? (JsonNode)this.tree : null;
                if (jsonNode != null) {
                    this.countFieldsRecursive(unwrapped, jsonNode);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void countFieldsRecursive(Object obj, JsonNode jsonNode) {
            obj = OneOfDeserializer.unwrapValue(obj);
            if (jsonNode != null && jsonNode.isNull()) {
                ++this.matched;
                return;
            }
            if (obj == null || jsonNode == null) {
                return;
            }
            if (OneOfDeserializer.isJsonNullable(obj)) {
                Object unwrapped = OneOfDeserializer.unwrapJsonNullable(obj);
                if (unwrapped != null) {
                    this.countFieldsRecursive(unwrapped, jsonNode);
                    return;
                }
                return;
            }
            if (OneOfDeserializer.isPrimitiveOrString(obj)) {
                ++this.matched;
                return;
            }
            if (obj.getClass().isEnum() || Reflections.isEnumWrapper(obj)) {
                ++this.matched;
                try {
                    Method isKnownMethod;
                    Boolean isKnown;
                    if (Reflections.isEnumWrapper(obj) && (isKnown = (Boolean)(isKnownMethod = obj.getClass().getMethod("isKnown", new Class[0])).invoke(obj, new Object[0])) != null && !isKnown.booleanValue()) {
                        ++this.inexact;
                        return;
                    }
                }
                catch (Exception isKnownMethod) {
                    // empty catch block
                }
                return;
            }
            try {
                if (obj instanceof Collection && jsonNode.isArray()) {
                    int index = 0;
                    for (Object element : (Collection)obj) {
                        if (element != null && index < jsonNode.size()) {
                            JsonNode elementNode = jsonNode.get(index);
                            this.countFieldsRecursive(element, elementNode);
                        }
                        ++index;
                    }
                    return;
                }
                if (obj instanceof Map && jsonNode.isObject()) {
                    for (Map.Entry entry : ((Map)obj).entrySet()) {
                        String key;
                        if (entry.getKey() == null || entry.getValue() == null || !jsonNode.has(key = entry.getKey().toString())) continue;
                        JsonNode valueNode = jsonNode.get(key);
                        this.countFieldsRecursive(entry.getValue(), valueNode);
                    }
                    return;
                }
                if (jsonNode.isObject() && !(obj instanceof Map)) {
                    for (Field field : obj.getClass().getDeclaredFields()) {
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        field.setAccessible(true);
                        Object fieldValue = field.get(obj);
                        String fieldName = this.getJsonFieldName(field);
                        if (fieldName == null) continue;
                        if (!jsonNode.has(fieldName)) {
                            ++this.unmatched;
                            continue;
                        }
                        JsonNode fieldNode = jsonNode.get(fieldName);
                        this.countFieldsRecursive(fieldValue, fieldNode);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private String getJsonFieldName(Field field) {
            if (field.isAnnotationPresent(JsonIgnore.class)) {
                return null;
            }
            if (field.isAnnotationPresent(JsonProperty.class)) {
                JsonProperty prop = field.getAnnotation(JsonProperty.class);
                String value = prop.value();
                if (value != null && !value.isEmpty()) {
                    return value;
                }
                return field.getName();
            }
            return null;
        }

        @Override
        public int compareTo(Match<T> other) {
            int matchedComparison = Integer.compare(this.matched, other.matched);
            if (matchedComparison != 0) {
                return matchedComparison;
            }
            int inexactComparison = Integer.compare(other.inexact, this.inexact);
            if (inexactComparison != 0) {
                return inexactComparison;
            }
            return Integer.compare(other.unmatched, this.unmatched);
        }
    }
}

