/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class AtsUpdateNotesRequestDto {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content")
    private JsonNullable<? extends List<NoteContentApiModel>> content;

    /**
     * Unique identifier of the author
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("author_id")
    private JsonNullable<String> authorId;

    /**
     * Visibility of the note
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("visibility")
    private JsonNullable<? extends AtsUpdateNotesRequestDtoVisibility> visibility;

    /**
     * Value to pass through to the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("passthrough")
    private JsonNullable<? extends Map<String, Object>> passthrough;

    @JsonCreator
    public AtsUpdateNotesRequestDto(
            @JsonProperty("content") JsonNullable<? extends List<NoteContentApiModel>> content,
            @JsonProperty("author_id") JsonNullable<String> authorId,
            @JsonProperty("visibility") JsonNullable<? extends AtsUpdateNotesRequestDtoVisibility> visibility,
            @JsonProperty("passthrough") JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(authorId, "authorId");
        Utils.checkNotNull(visibility, "visibility");
        Utils.checkNotNull(passthrough, "passthrough");
        this.content = content;
        this.authorId = authorId;
        this.visibility = visibility;
        this.passthrough = passthrough;
    }
    
    public AtsUpdateNotesRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<NoteContentApiModel>> content() {
        return (JsonNullable<List<NoteContentApiModel>>) content;
    }

    /**
     * Unique identifier of the author
     */
    @JsonIgnore
    public JsonNullable<String> authorId() {
        return authorId;
    }

    /**
     * Visibility of the note
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AtsUpdateNotesRequestDtoVisibility> visibility() {
        return (JsonNullable<AtsUpdateNotesRequestDtoVisibility>) visibility;
    }

    /**
     * Value to pass through to the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> passthrough() {
        return (JsonNullable<Map<String, Object>>) passthrough;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public AtsUpdateNotesRequestDto withContent(List<NoteContentApiModel> content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of(content);
        return this;
    }

    public AtsUpdateNotesRequestDto withContent(JsonNullable<? extends List<NoteContentApiModel>> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    /**
     * Unique identifier of the author
     */
    public AtsUpdateNotesRequestDto withAuthorId(String authorId) {
        Utils.checkNotNull(authorId, "authorId");
        this.authorId = JsonNullable.of(authorId);
        return this;
    }

    /**
     * Unique identifier of the author
     */
    public AtsUpdateNotesRequestDto withAuthorId(JsonNullable<String> authorId) {
        Utils.checkNotNull(authorId, "authorId");
        this.authorId = authorId;
        return this;
    }

    /**
     * Visibility of the note
     */
    public AtsUpdateNotesRequestDto withVisibility(AtsUpdateNotesRequestDtoVisibility visibility) {
        Utils.checkNotNull(visibility, "visibility");
        this.visibility = JsonNullable.of(visibility);
        return this;
    }

    /**
     * Visibility of the note
     */
    public AtsUpdateNotesRequestDto withVisibility(JsonNullable<? extends AtsUpdateNotesRequestDtoVisibility> visibility) {
        Utils.checkNotNull(visibility, "visibility");
        this.visibility = visibility;
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public AtsUpdateNotesRequestDto withPassthrough(Map<String, Object> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = JsonNullable.of(passthrough);
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public AtsUpdateNotesRequestDto withPassthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = passthrough;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsUpdateNotesRequestDto other = (AtsUpdateNotesRequestDto) o;
        return 
            Objects.deepEquals(this.content, other.content) &&
            Objects.deepEquals(this.authorId, other.authorId) &&
            Objects.deepEquals(this.visibility, other.visibility) &&
            Objects.deepEquals(this.passthrough, other.passthrough);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            content,
            authorId,
            visibility,
            passthrough);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsUpdateNotesRequestDto.class,
                "content", content,
                "authorId", authorId,
                "visibility", visibility,
                "passthrough", passthrough);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends List<NoteContentApiModel>> content = JsonNullable.undefined();
 
        private JsonNullable<String> authorId = JsonNullable.undefined();
 
        private JsonNullable<? extends AtsUpdateNotesRequestDtoVisibility> visibility = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> passthrough = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder content(List<NoteContentApiModel> content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of(content);
            return this;
        }

        public Builder content(JsonNullable<? extends List<NoteContentApiModel>> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }

        /**
         * Unique identifier of the author
         */
        public Builder authorId(String authorId) {
            Utils.checkNotNull(authorId, "authorId");
            this.authorId = JsonNullable.of(authorId);
            return this;
        }

        /**
         * Unique identifier of the author
         */
        public Builder authorId(JsonNullable<String> authorId) {
            Utils.checkNotNull(authorId, "authorId");
            this.authorId = authorId;
            return this;
        }

        /**
         * Visibility of the note
         */
        public Builder visibility(AtsUpdateNotesRequestDtoVisibility visibility) {
            Utils.checkNotNull(visibility, "visibility");
            this.visibility = JsonNullable.of(visibility);
            return this;
        }

        /**
         * Visibility of the note
         */
        public Builder visibility(JsonNullable<? extends AtsUpdateNotesRequestDtoVisibility> visibility) {
            Utils.checkNotNull(visibility, "visibility");
            this.visibility = visibility;
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(Map<String, Object> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = JsonNullable.of(passthrough);
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = passthrough;
            return this;
        }
        
        public AtsUpdateNotesRequestDto build() {
            return new AtsUpdateNotesRequestDto(
                content,
                authorId,
                visibility,
                passthrough);
        }
    }
}
