/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class AttachmentContentType {

    /**
     * The content type of the attachment.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends AttachmentValue> value;

    /**
     * The source value of the content type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends AttachmentSourceValue> sourceValue;

    @JsonCreator
    public AttachmentContentType(
            @JsonProperty("value") JsonNullable<? extends AttachmentValue> value,
            @JsonProperty("source_value") JsonNullable<? extends AttachmentSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public AttachmentContentType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The content type of the attachment.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AttachmentValue> value() {
        return (JsonNullable<AttachmentValue>) value;
    }

    /**
     * The source value of the content type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AttachmentSourceValue> sourceValue() {
        return (JsonNullable<AttachmentSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The content type of the attachment.
     */
    public AttachmentContentType withValue(AttachmentValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The content type of the attachment.
     */
    public AttachmentContentType withValue(JsonNullable<? extends AttachmentValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the content type.
     */
    public AttachmentContentType withSourceValue(AttachmentSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the content type.
     */
    public AttachmentContentType withSourceValue(JsonNullable<? extends AttachmentSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AttachmentContentType other = (AttachmentContentType) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AttachmentContentType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends AttachmentValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends AttachmentSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The content type of the attachment.
         */
        public Builder value(AttachmentValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The content type of the attachment.
         */
        public Builder value(JsonNullable<? extends AttachmentValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the content type.
         */
        public Builder sourceValue(AttachmentSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the content type.
         */
        public Builder sourceValue(JsonNullable<? extends AttachmentSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public AttachmentContentType build() {
            return new AttachmentContentType(
                value,
                sourceValue);
        }
    }
}
