/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * ContentBlockStatus
 * 
 * <p>Stackone enum identifying the status of content block.
 */
public class ContentBlockStatus {

    /**
     * The Status of the content blocks.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends ContentBlockStatusValue> value;

    /**
     * The source value of the status.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends ContentBlockStatusSourceValue> sourceValue;

    @JsonCreator
    public ContentBlockStatus(
            @JsonProperty("value") JsonNullable<? extends ContentBlockStatusValue> value,
            @JsonProperty("source_value") JsonNullable<? extends ContentBlockStatusSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public ContentBlockStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The Status of the content blocks.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ContentBlockStatusValue> value() {
        return (JsonNullable<ContentBlockStatusValue>) value;
    }

    /**
     * The source value of the status.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ContentBlockStatusSourceValue> sourceValue() {
        return (JsonNullable<ContentBlockStatusSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The Status of the content blocks.
     */
    public ContentBlockStatus withValue(ContentBlockStatusValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The Status of the content blocks.
     */
    public ContentBlockStatus withValue(JsonNullable<? extends ContentBlockStatusValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the status.
     */
    public ContentBlockStatus withSourceValue(ContentBlockStatusSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the status.
     */
    public ContentBlockStatus withSourceValue(JsonNullable<? extends ContentBlockStatusSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ContentBlockStatus other = (ContentBlockStatus) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ContentBlockStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends ContentBlockStatusValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends ContentBlockStatusSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The Status of the content blocks.
         */
        public Builder value(ContentBlockStatusValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The Status of the content blocks.
         */
        public Builder value(JsonNullable<? extends ContentBlockStatusValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the status.
         */
        public Builder sourceValue(ContentBlockStatusSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the status.
         */
        public Builder sourceValue(JsonNullable<? extends ContentBlockStatusSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public ContentBlockStatus build() {
            return new ContentBlockStatus(
                value,
                sourceValue);
        }
    }
}
