/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class CrmCreateContactRequestDto {

    /**
     * The contact first name
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("first_name")
    private JsonNullable<String> firstName;

    /**
     * The contact last name
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("last_name")
    private JsonNullable<String> lastName;

    /**
     * The contact company name
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("company_name")
    private JsonNullable<String> companyName;

    /**
     * List of contact email addresses
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("emails")
    private JsonNullable<? extends List<String>> emails;

    /**
     * List of contact phone numbers
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone_numbers")
    private JsonNullable<? extends List<String>> phoneNumbers;

    /**
     * List of associated deal IDs
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("deal_ids")
    private JsonNullable<? extends List<String>> dealIds;

    /**
     * List of associated account IDs
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("account_ids")
    private JsonNullable<? extends List<String>> accountIds;

    /**
     * Contact custom fields
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("custom_fields")
    private JsonNullable<? extends List<CustomFields>> customFields;

    /**
     * Value to pass through to the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("passthrough")
    private JsonNullable<? extends Map<String, Object>> passthrough;

    @JsonCreator
    public CrmCreateContactRequestDto(
            @JsonProperty("first_name") JsonNullable<String> firstName,
            @JsonProperty("last_name") JsonNullable<String> lastName,
            @JsonProperty("company_name") JsonNullable<String> companyName,
            @JsonProperty("emails") JsonNullable<? extends List<String>> emails,
            @JsonProperty("phone_numbers") JsonNullable<? extends List<String>> phoneNumbers,
            @JsonProperty("deal_ids") JsonNullable<? extends List<String>> dealIds,
            @JsonProperty("account_ids") JsonNullable<? extends List<String>> accountIds,
            @JsonProperty("custom_fields") JsonNullable<? extends List<CustomFields>> customFields,
            @JsonProperty("passthrough") JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(companyName, "companyName");
        Utils.checkNotNull(emails, "emails");
        Utils.checkNotNull(phoneNumbers, "phoneNumbers");
        Utils.checkNotNull(dealIds, "dealIds");
        Utils.checkNotNull(accountIds, "accountIds");
        Utils.checkNotNull(customFields, "customFields");
        Utils.checkNotNull(passthrough, "passthrough");
        this.firstName = firstName;
        this.lastName = lastName;
        this.companyName = companyName;
        this.emails = emails;
        this.phoneNumbers = phoneNumbers;
        this.dealIds = dealIds;
        this.accountIds = accountIds;
        this.customFields = customFields;
        this.passthrough = passthrough;
    }
    
    public CrmCreateContactRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The contact first name
     */
    @JsonIgnore
    public JsonNullable<String> firstName() {
        return firstName;
    }

    /**
     * The contact last name
     */
    @JsonIgnore
    public JsonNullable<String> lastName() {
        return lastName;
    }

    /**
     * The contact company name
     */
    @JsonIgnore
    public JsonNullable<String> companyName() {
        return companyName;
    }

    /**
     * List of contact email addresses
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> emails() {
        return (JsonNullable<List<String>>) emails;
    }

    /**
     * List of contact phone numbers
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> phoneNumbers() {
        return (JsonNullable<List<String>>) phoneNumbers;
    }

    /**
     * List of associated deal IDs
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> dealIds() {
        return (JsonNullable<List<String>>) dealIds;
    }

    /**
     * List of associated account IDs
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> accountIds() {
        return (JsonNullable<List<String>>) accountIds;
    }

    /**
     * Contact custom fields
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<CustomFields>> customFields() {
        return (JsonNullable<List<CustomFields>>) customFields;
    }

    /**
     * Value to pass through to the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> passthrough() {
        return (JsonNullable<Map<String, Object>>) passthrough;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The contact first name
     */
    public CrmCreateContactRequestDto withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = JsonNullable.of(firstName);
        return this;
    }

    /**
     * The contact first name
     */
    public CrmCreateContactRequestDto withFirstName(JsonNullable<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    /**
     * The contact last name
     */
    public CrmCreateContactRequestDto withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = JsonNullable.of(lastName);
        return this;
    }

    /**
     * The contact last name
     */
    public CrmCreateContactRequestDto withLastName(JsonNullable<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    /**
     * The contact company name
     */
    public CrmCreateContactRequestDto withCompanyName(String companyName) {
        Utils.checkNotNull(companyName, "companyName");
        this.companyName = JsonNullable.of(companyName);
        return this;
    }

    /**
     * The contact company name
     */
    public CrmCreateContactRequestDto withCompanyName(JsonNullable<String> companyName) {
        Utils.checkNotNull(companyName, "companyName");
        this.companyName = companyName;
        return this;
    }

    /**
     * List of contact email addresses
     */
    public CrmCreateContactRequestDto withEmails(List<String> emails) {
        Utils.checkNotNull(emails, "emails");
        this.emails = JsonNullable.of(emails);
        return this;
    }

    /**
     * List of contact email addresses
     */
    public CrmCreateContactRequestDto withEmails(JsonNullable<? extends List<String>> emails) {
        Utils.checkNotNull(emails, "emails");
        this.emails = emails;
        return this;
    }

    /**
     * List of contact phone numbers
     */
    public CrmCreateContactRequestDto withPhoneNumbers(List<String> phoneNumbers) {
        Utils.checkNotNull(phoneNumbers, "phoneNumbers");
        this.phoneNumbers = JsonNullable.of(phoneNumbers);
        return this;
    }

    /**
     * List of contact phone numbers
     */
    public CrmCreateContactRequestDto withPhoneNumbers(JsonNullable<? extends List<String>> phoneNumbers) {
        Utils.checkNotNull(phoneNumbers, "phoneNumbers");
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    /**
     * List of associated deal IDs
     */
    public CrmCreateContactRequestDto withDealIds(List<String> dealIds) {
        Utils.checkNotNull(dealIds, "dealIds");
        this.dealIds = JsonNullable.of(dealIds);
        return this;
    }

    /**
     * List of associated deal IDs
     */
    public CrmCreateContactRequestDto withDealIds(JsonNullable<? extends List<String>> dealIds) {
        Utils.checkNotNull(dealIds, "dealIds");
        this.dealIds = dealIds;
        return this;
    }

    /**
     * List of associated account IDs
     */
    public CrmCreateContactRequestDto withAccountIds(List<String> accountIds) {
        Utils.checkNotNull(accountIds, "accountIds");
        this.accountIds = JsonNullable.of(accountIds);
        return this;
    }

    /**
     * List of associated account IDs
     */
    public CrmCreateContactRequestDto withAccountIds(JsonNullable<? extends List<String>> accountIds) {
        Utils.checkNotNull(accountIds, "accountIds");
        this.accountIds = accountIds;
        return this;
    }

    /**
     * Contact custom fields
     */
    public CrmCreateContactRequestDto withCustomFields(List<CustomFields> customFields) {
        Utils.checkNotNull(customFields, "customFields");
        this.customFields = JsonNullable.of(customFields);
        return this;
    }

    /**
     * Contact custom fields
     */
    public CrmCreateContactRequestDto withCustomFields(JsonNullable<? extends List<CustomFields>> customFields) {
        Utils.checkNotNull(customFields, "customFields");
        this.customFields = customFields;
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public CrmCreateContactRequestDto withPassthrough(Map<String, Object> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = JsonNullable.of(passthrough);
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public CrmCreateContactRequestDto withPassthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = passthrough;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CrmCreateContactRequestDto other = (CrmCreateContactRequestDto) o;
        return 
            Objects.deepEquals(this.firstName, other.firstName) &&
            Objects.deepEquals(this.lastName, other.lastName) &&
            Objects.deepEquals(this.companyName, other.companyName) &&
            Objects.deepEquals(this.emails, other.emails) &&
            Objects.deepEquals(this.phoneNumbers, other.phoneNumbers) &&
            Objects.deepEquals(this.dealIds, other.dealIds) &&
            Objects.deepEquals(this.accountIds, other.accountIds) &&
            Objects.deepEquals(this.customFields, other.customFields) &&
            Objects.deepEquals(this.passthrough, other.passthrough);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            firstName,
            lastName,
            companyName,
            emails,
            phoneNumbers,
            dealIds,
            accountIds,
            customFields,
            passthrough);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CrmCreateContactRequestDto.class,
                "firstName", firstName,
                "lastName", lastName,
                "companyName", companyName,
                "emails", emails,
                "phoneNumbers", phoneNumbers,
                "dealIds", dealIds,
                "accountIds", accountIds,
                "customFields", customFields,
                "passthrough", passthrough);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> firstName = JsonNullable.undefined();
 
        private JsonNullable<String> lastName = JsonNullable.undefined();
 
        private JsonNullable<String> companyName = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> emails = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> phoneNumbers = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> dealIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> accountIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<CustomFields>> customFields = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> passthrough = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The contact first name
         */
        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = JsonNullable.of(firstName);
            return this;
        }

        /**
         * The contact first name
         */
        public Builder firstName(JsonNullable<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        /**
         * The contact last name
         */
        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = JsonNullable.of(lastName);
            return this;
        }

        /**
         * The contact last name
         */
        public Builder lastName(JsonNullable<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        /**
         * The contact company name
         */
        public Builder companyName(String companyName) {
            Utils.checkNotNull(companyName, "companyName");
            this.companyName = JsonNullable.of(companyName);
            return this;
        }

        /**
         * The contact company name
         */
        public Builder companyName(JsonNullable<String> companyName) {
            Utils.checkNotNull(companyName, "companyName");
            this.companyName = companyName;
            return this;
        }

        /**
         * List of contact email addresses
         */
        public Builder emails(List<String> emails) {
            Utils.checkNotNull(emails, "emails");
            this.emails = JsonNullable.of(emails);
            return this;
        }

        /**
         * List of contact email addresses
         */
        public Builder emails(JsonNullable<? extends List<String>> emails) {
            Utils.checkNotNull(emails, "emails");
            this.emails = emails;
            return this;
        }

        /**
         * List of contact phone numbers
         */
        public Builder phoneNumbers(List<String> phoneNumbers) {
            Utils.checkNotNull(phoneNumbers, "phoneNumbers");
            this.phoneNumbers = JsonNullable.of(phoneNumbers);
            return this;
        }

        /**
         * List of contact phone numbers
         */
        public Builder phoneNumbers(JsonNullable<? extends List<String>> phoneNumbers) {
            Utils.checkNotNull(phoneNumbers, "phoneNumbers");
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        /**
         * List of associated deal IDs
         */
        public Builder dealIds(List<String> dealIds) {
            Utils.checkNotNull(dealIds, "dealIds");
            this.dealIds = JsonNullable.of(dealIds);
            return this;
        }

        /**
         * List of associated deal IDs
         */
        public Builder dealIds(JsonNullable<? extends List<String>> dealIds) {
            Utils.checkNotNull(dealIds, "dealIds");
            this.dealIds = dealIds;
            return this;
        }

        /**
         * List of associated account IDs
         */
        public Builder accountIds(List<String> accountIds) {
            Utils.checkNotNull(accountIds, "accountIds");
            this.accountIds = JsonNullable.of(accountIds);
            return this;
        }

        /**
         * List of associated account IDs
         */
        public Builder accountIds(JsonNullable<? extends List<String>> accountIds) {
            Utils.checkNotNull(accountIds, "accountIds");
            this.accountIds = accountIds;
            return this;
        }

        /**
         * Contact custom fields
         */
        public Builder customFields(List<CustomFields> customFields) {
            Utils.checkNotNull(customFields, "customFields");
            this.customFields = JsonNullable.of(customFields);
            return this;
        }

        /**
         * Contact custom fields
         */
        public Builder customFields(JsonNullable<? extends List<CustomFields>> customFields) {
            Utils.checkNotNull(customFields, "customFields");
            this.customFields = customFields;
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(Map<String, Object> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = JsonNullable.of(passthrough);
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = passthrough;
            return this;
        }
        
        public CrmCreateContactRequestDto build() {
            return new CrmCreateContactRequestDto(
                firstName,
                lastName,
                companyName,
                emails,
                phoneNumbers,
                dealIds,
                accountIds,
                customFields,
                passthrough);
        }
    }
}
