/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
@JsonDeserialize(using = TimeOffTypeValue._Deserializer.class)
@JsonSerialize(using = TimeOffTypeValue._Serializer.class)
public class TimeOffTypeValue {

    public static final TimeOffTypeValue SICK = new TimeOffTypeValue("sick");
    public static final TimeOffTypeValue UNMAPPED_VALUE = new TimeOffTypeValue("unmapped_value");
    public static final TimeOffTypeValue VACATION = new TimeOffTypeValue("vacation");
    public static final TimeOffTypeValue LONG_TERM_DISABILITY = new TimeOffTypeValue("long_term_disability");
    public static final TimeOffTypeValue SHORT_TERM_DISABILITY = new TimeOffTypeValue("short_term_disability");
    public static final TimeOffTypeValue ABSENT = new TimeOffTypeValue("absent");
    public static final TimeOffTypeValue COMP_TIME = new TimeOffTypeValue("comp_time");
    public static final TimeOffTypeValue TRAINING = new TimeOffTypeValue("training");
    public static final TimeOffTypeValue ANNUAL_LEAVE = new TimeOffTypeValue("annual_leave");
    public static final TimeOffTypeValue LEAVE_OF_ABSENCE = new TimeOffTypeValue("leave_of_absence");
    public static final TimeOffTypeValue BREAK = new TimeOffTypeValue("break");
    public static final TimeOffTypeValue CHILD_CARE_LEAVE = new TimeOffTypeValue("child_care_leave");
    public static final TimeOffTypeValue MATERNITY_LEAVE = new TimeOffTypeValue("maternity_leave");
    public static final TimeOffTypeValue JURY_DUTY = new TimeOffTypeValue("jury_duty");
    public static final TimeOffTypeValue BEREAVEMENT_LEAVE = new TimeOffTypeValue("bereavement_leave");
    public static final TimeOffTypeValue SABBATICAL = new TimeOffTypeValue("sabbatical");
    public static final TimeOffTypeValue ACCIDENT = new TimeOffTypeValue("accident");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TimeOffTypeValue> values = createValuesMap();
    private static final Map<String, TimeOffTypeValueEnum> enums = createEnumsMap();

    private final String value;

    private TimeOffTypeValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TimeOffTypeValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TimeOffTypeValue
     */ 
    public static TimeOffTypeValue of(String value) {
        synchronized (TimeOffTypeValue.class) {
            return values.computeIfAbsent(value, v -> new TimeOffTypeValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<TimeOffTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TimeOffTypeValue other = (TimeOffTypeValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TimeOffTypeValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TimeOffTypeValue[] values() {
        synchronized (TimeOffTypeValue.class) {
            return values.values().toArray(new TimeOffTypeValue[] {});
        }
    }

    private static final Map<String, TimeOffTypeValue> createValuesMap() {
        Map<String, TimeOffTypeValue> map = new LinkedHashMap<>();
        map.put("sick", SICK);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("vacation", VACATION);
        map.put("long_term_disability", LONG_TERM_DISABILITY);
        map.put("short_term_disability", SHORT_TERM_DISABILITY);
        map.put("absent", ABSENT);
        map.put("comp_time", COMP_TIME);
        map.put("training", TRAINING);
        map.put("annual_leave", ANNUAL_LEAVE);
        map.put("leave_of_absence", LEAVE_OF_ABSENCE);
        map.put("break", BREAK);
        map.put("child_care_leave", CHILD_CARE_LEAVE);
        map.put("maternity_leave", MATERNITY_LEAVE);
        map.put("jury_duty", JURY_DUTY);
        map.put("bereavement_leave", BEREAVEMENT_LEAVE);
        map.put("sabbatical", SABBATICAL);
        map.put("accident", ACCIDENT);
        return map;
    }

    private static final Map<String, TimeOffTypeValueEnum> createEnumsMap() {
        Map<String, TimeOffTypeValueEnum> map = new HashMap<>();
        map.put("sick", TimeOffTypeValueEnum.SICK);
        map.put("unmapped_value", TimeOffTypeValueEnum.UNMAPPED_VALUE);
        map.put("vacation", TimeOffTypeValueEnum.VACATION);
        map.put("long_term_disability", TimeOffTypeValueEnum.LONG_TERM_DISABILITY);
        map.put("short_term_disability", TimeOffTypeValueEnum.SHORT_TERM_DISABILITY);
        map.put("absent", TimeOffTypeValueEnum.ABSENT);
        map.put("comp_time", TimeOffTypeValueEnum.COMP_TIME);
        map.put("training", TimeOffTypeValueEnum.TRAINING);
        map.put("annual_leave", TimeOffTypeValueEnum.ANNUAL_LEAVE);
        map.put("leave_of_absence", TimeOffTypeValueEnum.LEAVE_OF_ABSENCE);
        map.put("break", TimeOffTypeValueEnum.BREAK);
        map.put("child_care_leave", TimeOffTypeValueEnum.CHILD_CARE_LEAVE);
        map.put("maternity_leave", TimeOffTypeValueEnum.MATERNITY_LEAVE);
        map.put("jury_duty", TimeOffTypeValueEnum.JURY_DUTY);
        map.put("bereavement_leave", TimeOffTypeValueEnum.BEREAVEMENT_LEAVE);
        map.put("sabbatical", TimeOffTypeValueEnum.SABBATICAL);
        map.put("accident", TimeOffTypeValueEnum.ACCIDENT);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<TimeOffTypeValue> {

        protected _Serializer() {
            super(TimeOffTypeValue.class);
        }

        @Override
        public void serialize(TimeOffTypeValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<TimeOffTypeValue> {

        protected _Deserializer() {
            super(TimeOffTypeValue.class);
        }

        @Override
        public TimeOffTypeValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return TimeOffTypeValue.of(v);
        }
    }
    
    public enum TimeOffTypeValueEnum {

        SICK("sick"),
        UNMAPPED_VALUE("unmapped_value"),
        VACATION("vacation"),
        LONG_TERM_DISABILITY("long_term_disability"),
        SHORT_TERM_DISABILITY("short_term_disability"),
        ABSENT("absent"),
        COMP_TIME("comp_time"),
        TRAINING("training"),
        ANNUAL_LEAVE("annual_leave"),
        LEAVE_OF_ABSENCE("leave_of_absence"),
        BREAK("break"),
        CHILD_CARE_LEAVE("child_care_leave"),
        MATERNITY_LEAVE("maternity_leave"),
        JURY_DUTY("jury_duty"),
        BEREAVEMENT_LEAVE("bereavement_leave"),
        SABBATICAL("sabbatical"),
        ACCIDENT("accident"),;

        private final String value;

        private TimeOffTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

