/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * Data
 * 
 * <p>Error details
 */
public class Data {

    /**
     * HTTP status code
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("statusCode")
    private JsonNullable<Double> statusCode;

    /**
     * Error message
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("message")
    private JsonNullable<String> message;

    /**
     * Response headers
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("headers")
    private JsonNullable<? extends Headers> headers;

    @JsonCreator
    public Data(
            @JsonProperty("statusCode") JsonNullable<Double> statusCode,
            @JsonProperty("message") JsonNullable<String> message,
            @JsonProperty("headers") JsonNullable<? extends Headers> headers) {
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(headers, "headers");
        this.statusCode = statusCode;
        this.message = message;
        this.headers = headers;
    }
    
    public Data() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * HTTP status code
     */
    @JsonIgnore
    public JsonNullable<Double> statusCode() {
        return statusCode;
    }

    /**
     * Error message
     */
    @JsonIgnore
    public JsonNullable<String> message() {
        return message;
    }

    /**
     * Response headers
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Headers> headers() {
        return (JsonNullable<Headers>) headers;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * HTTP status code
     */
    public Data withStatusCode(double statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = JsonNullable.of(statusCode);
        return this;
    }

    /**
     * HTTP status code
     */
    public Data withStatusCode(JsonNullable<Double> statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Error message
     */
    public Data withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = JsonNullable.of(message);
        return this;
    }

    /**
     * Error message
     */
    public Data withMessage(JsonNullable<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    /**
     * Response headers
     */
    public Data withHeaders(Headers headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of(headers);
        return this;
    }

    /**
     * Response headers
     */
    public Data withHeaders(JsonNullable<? extends Headers> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Data other = (Data) o;
        return 
            Objects.deepEquals(this.statusCode, other.statusCode) &&
            Objects.deepEquals(this.message, other.message) &&
            Objects.deepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            statusCode,
            message,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Data.class,
                "statusCode", statusCode,
                "message", message,
                "headers", headers);
    }
    
    public final static class Builder {
 
        private JsonNullable<Double> statusCode = JsonNullable.undefined();
 
        private JsonNullable<String> message = JsonNullable.undefined();
 
        private JsonNullable<? extends Headers> headers = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP status code
         */
        public Builder statusCode(double statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = JsonNullable.of(statusCode);
            return this;
        }

        /**
         * HTTP status code
         */
        public Builder statusCode(JsonNullable<Double> statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Error message
         */
        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = JsonNullable.of(message);
            return this;
        }

        /**
         * Error message
         */
        public Builder message(JsonNullable<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        /**
         * Response headers
         */
        public Builder headers(Headers headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of(headers);
            return this;
        }

        /**
         * Response headers
         */
        public Builder headers(JsonNullable<? extends Headers> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }
        
        public Data build() {
            return new Data(
                statusCode,
                message,
                headers);
        }
    }
}
