/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.time.OffsetDateTime;
import java.util.Objects;

public class UpdateResult {
    @JsonProperty(value="statusCode")
    private double statusCode;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="timestamp")
    private OffsetDateTime timestamp;

    @JsonCreator
    public UpdateResult(@JsonProperty(value="statusCode") double statusCode, @JsonProperty(value="message") String message, @JsonProperty(value="timestamp") OffsetDateTime timestamp) {
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(timestamp, "timestamp");
        this.statusCode = statusCode;
        this.message = message;
        this.timestamp = timestamp;
    }

    @JsonIgnore
    public double statusCode() {
        return this.statusCode;
    }

    @JsonIgnore
    public String message() {
        return this.message;
    }

    @JsonIgnore
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public UpdateResult withStatusCode(double statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public UpdateResult withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public UpdateResult withTimestamp(OffsetDateTime timestamp) {
        Utils.checkNotNull(timestamp, "timestamp");
        this.timestamp = timestamp;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateResult other = (UpdateResult)o;
        return Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.message, other.message) && Objects.deepEquals(this.timestamp, other.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.statusCode, this.message, this.timestamp);
    }

    public String toString() {
        return Utils.toString(UpdateResult.class, "statusCode", this.statusCode, "message", this.message, "timestamp", this.timestamp);
    }

    public static final class Builder {
        private Double statusCode;
        private String message;
        private OffsetDateTime timestamp;

        private Builder() {
        }

        public Builder statusCode(double statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Builder timestamp(OffsetDateTime timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }

        public UpdateResult build() {
            return new UpdateResult(this.statusCode, this.message, this.timestamp);
        }
    }
}

