/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * CreateMessageMessageType
 * 
 * <p>Stackone enum identifying the type of message associated with the content.
 */
public class CreateMessageMessageType {

    /**
     * The unified message type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends CreateMessageValue> value;

    /**
     * The original value from the provider used to derive the unified message type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends CreateMessageSourceValue> sourceValue;

    @JsonCreator
    public CreateMessageMessageType(
            @JsonProperty("value") JsonNullable<? extends CreateMessageValue> value,
            @JsonProperty("source_value") JsonNullable<? extends CreateMessageSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public CreateMessageMessageType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The unified message type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CreateMessageValue> value() {
        return (JsonNullable<CreateMessageValue>) value;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CreateMessageSourceValue> sourceValue() {
        return (JsonNullable<CreateMessageSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The unified message type.
     */
    public CreateMessageMessageType withValue(CreateMessageValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The unified message type.
     */
    public CreateMessageMessageType withValue(JsonNullable<? extends CreateMessageValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    public CreateMessageMessageType withSourceValue(CreateMessageSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The original value from the provider used to derive the unified message type.
     */
    public CreateMessageMessageType withSourceValue(JsonNullable<? extends CreateMessageSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateMessageMessageType other = (CreateMessageMessageType) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CreateMessageMessageType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends CreateMessageValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends CreateMessageSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The unified message type.
         */
        public Builder value(CreateMessageValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The unified message type.
         */
        public Builder value(JsonNullable<? extends CreateMessageValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The original value from the provider used to derive the unified message type.
         */
        public Builder sourceValue(CreateMessageSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The original value from the provider used to derive the unified message type.
         */
        public Builder sourceValue(JsonNullable<? extends CreateMessageSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public CreateMessageMessageType build() {
            return new CreateMessageMessageType(
                value,
                sourceValue);
        }
    }
}
