/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class JobPostingStatus {

    /**
     * The status of the job postings.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends JobPostingValue> value;

    /**
     * The source value of the job postings status.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends JobPostingSourceValue> sourceValue;

    @JsonCreator
    public JobPostingStatus(
            @JsonProperty("value") JsonNullable<? extends JobPostingValue> value,
            @JsonProperty("source_value") JsonNullable<? extends JobPostingSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public JobPostingStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The status of the job postings.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<JobPostingValue> value() {
        return (JsonNullable<JobPostingValue>) value;
    }

    /**
     * The source value of the job postings status.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<JobPostingSourceValue> sourceValue() {
        return (JsonNullable<JobPostingSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The status of the job postings.
     */
    public JobPostingStatus withValue(JobPostingValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The status of the job postings.
     */
    public JobPostingStatus withValue(JsonNullable<? extends JobPostingValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the job postings status.
     */
    public JobPostingStatus withSourceValue(JobPostingSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the job postings status.
     */
    public JobPostingStatus withSourceValue(JsonNullable<? extends JobPostingSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JobPostingStatus other = (JobPostingStatus) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(JobPostingStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends JobPostingValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends JobPostingSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The status of the job postings.
         */
        public Builder value(JobPostingValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The status of the job postings.
         */
        public Builder value(JsonNullable<? extends JobPostingValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the job postings status.
         */
        public Builder sourceValue(JobPostingSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the job postings status.
         */
        public Builder sourceValue(JsonNullable<? extends JobPostingSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public JobPostingStatus build() {
            return new JobPostingStatus(
                value,
                sourceValue);
        }
    }
}
