/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class OfferHistory {

    /**
     * Start Date of the offer
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_date")
    private JsonNullable<OffsetDateTime> startDate;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("salary")
    private JsonNullable<Double> salary;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("currency")
    private JsonNullable<String> currency;

    /**
     * Date of creation
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * Date of last update
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public OfferHistory(
            @JsonProperty("start_date") JsonNullable<OffsetDateTime> startDate,
            @JsonProperty("salary") JsonNullable<Double> salary,
            @JsonProperty("currency") JsonNullable<String> currency,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(startDate, "startDate");
        Utils.checkNotNull(salary, "salary");
        Utils.checkNotNull(currency, "currency");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.startDate = startDate;
        this.salary = salary;
        this.currency = currency;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public OfferHistory() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Start Date of the offer
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startDate() {
        return startDate;
    }

    @JsonIgnore
    public JsonNullable<Double> salary() {
        return salary;
    }

    @JsonIgnore
    public JsonNullable<String> currency() {
        return currency;
    }

    /**
     * Date of creation
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * Date of last update
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Start Date of the offer
     */
    public OfferHistory withStartDate(OffsetDateTime startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = JsonNullable.of(startDate);
        return this;
    }

    /**
     * Start Date of the offer
     */
    public OfferHistory withStartDate(JsonNullable<OffsetDateTime> startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = startDate;
        return this;
    }

    public OfferHistory withSalary(double salary) {
        Utils.checkNotNull(salary, "salary");
        this.salary = JsonNullable.of(salary);
        return this;
    }

    public OfferHistory withSalary(JsonNullable<Double> salary) {
        Utils.checkNotNull(salary, "salary");
        this.salary = salary;
        return this;
    }

    public OfferHistory withCurrency(String currency) {
        Utils.checkNotNull(currency, "currency");
        this.currency = JsonNullable.of(currency);
        return this;
    }

    public OfferHistory withCurrency(JsonNullable<String> currency) {
        Utils.checkNotNull(currency, "currency");
        this.currency = currency;
        return this;
    }

    /**
     * Date of creation
     */
    public OfferHistory withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * Date of creation
     */
    public OfferHistory withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Date of last update
     */
    public OfferHistory withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * Date of last update
     */
    public OfferHistory withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OfferHistory other = (OfferHistory) o;
        return 
            Objects.deepEquals(this.startDate, other.startDate) &&
            Objects.deepEquals(this.salary, other.salary) &&
            Objects.deepEquals(this.currency, other.currency) &&
            Objects.deepEquals(this.createdAt, other.createdAt) &&
            Objects.deepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            startDate,
            salary,
            currency,
            createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(OfferHistory.class,
                "startDate", startDate,
                "salary", salary,
                "currency", currency,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }
    
    public final static class Builder {
 
        private JsonNullable<OffsetDateTime> startDate = JsonNullable.undefined();
 
        private JsonNullable<Double> salary = JsonNullable.undefined();
 
        private JsonNullable<String> currency = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Start Date of the offer
         */
        public Builder startDate(OffsetDateTime startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = JsonNullable.of(startDate);
            return this;
        }

        /**
         * Start Date of the offer
         */
        public Builder startDate(JsonNullable<OffsetDateTime> startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder salary(double salary) {
            Utils.checkNotNull(salary, "salary");
            this.salary = JsonNullable.of(salary);
            return this;
        }

        public Builder salary(JsonNullable<Double> salary) {
            Utils.checkNotNull(salary, "salary");
            this.salary = salary;
            return this;
        }

        public Builder currency(String currency) {
            Utils.checkNotNull(currency, "currency");
            this.currency = JsonNullable.of(currency);
            return this;
        }

        public Builder currency(JsonNullable<String> currency) {
            Utils.checkNotNull(currency, "currency");
            this.currency = currency;
            return this;
        }

        /**
         * Date of creation
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * Date of creation
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * Date of last update
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * Date of last update
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }
        
        public OfferHistory build() {
            return new OfferHistory(
                startDate,
                salary,
                currency,
                createdAt,
                updatedAt);
        }
    }
}
