/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * ScheduleType
 * 
 * <p>The schedule type
 */
public class ScheduleType {

    /**
     * The schedule type of the campaign.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends CampaignValue> value;

    /**
     * The source value of the schedule type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends CampaignSourceValue> sourceValue;

    @JsonCreator
    public ScheduleType(
            @JsonProperty("value") JsonNullable<? extends CampaignValue> value,
            @JsonProperty("source_value") JsonNullable<? extends CampaignSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public ScheduleType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The schedule type of the campaign.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CampaignValue> value() {
        return (JsonNullable<CampaignValue>) value;
    }

    /**
     * The source value of the schedule type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CampaignSourceValue> sourceValue() {
        return (JsonNullable<CampaignSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The schedule type of the campaign.
     */
    public ScheduleType withValue(CampaignValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The schedule type of the campaign.
     */
    public ScheduleType withValue(JsonNullable<? extends CampaignValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the schedule type.
     */
    public ScheduleType withSourceValue(CampaignSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the schedule type.
     */
    public ScheduleType withSourceValue(JsonNullable<? extends CampaignSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ScheduleType other = (ScheduleType) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ScheduleType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends CampaignValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends CampaignSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The schedule type of the campaign.
         */
        public Builder value(CampaignValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The schedule type of the campaign.
         */
        public Builder value(JsonNullable<? extends CampaignValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the schedule type.
         */
        public Builder sourceValue(CampaignSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the schedule type.
         */
        public Builder sourceValue(JsonNullable<? extends CampaignSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public ScheduleType build() {
            return new ScheduleType(
                value,
                sourceValue);
        }
    }
}
