/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * WorkEligibilityFileFormat
 * 
 * <p>The file format of the file
 */
public class WorkEligibilityFileFormat {

    /**
     * The file format of the file, expressed as a file extension
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends WorkEligibilityDocumentValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends WorkEligibilityDocumentFileFormatSourceValue> sourceValue;

    @JsonCreator
    public WorkEligibilityFileFormat(
            @JsonProperty("value") JsonNullable<? extends WorkEligibilityDocumentValue> value,
            @JsonProperty("source_value") JsonNullable<? extends WorkEligibilityDocumentFileFormatSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public WorkEligibilityFileFormat() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The file format of the file, expressed as a file extension
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<WorkEligibilityDocumentValue> value() {
        return (JsonNullable<WorkEligibilityDocumentValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<WorkEligibilityDocumentFileFormatSourceValue> sourceValue() {
        return (JsonNullable<WorkEligibilityDocumentFileFormatSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The file format of the file, expressed as a file extension
     */
    public WorkEligibilityFileFormat withValue(WorkEligibilityDocumentValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The file format of the file, expressed as a file extension
     */
    public WorkEligibilityFileFormat withValue(JsonNullable<? extends WorkEligibilityDocumentValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public WorkEligibilityFileFormat withSourceValue(WorkEligibilityDocumentFileFormatSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public WorkEligibilityFileFormat withSourceValue(JsonNullable<? extends WorkEligibilityDocumentFileFormatSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WorkEligibilityFileFormat other = (WorkEligibilityFileFormat) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(WorkEligibilityFileFormat.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends WorkEligibilityDocumentValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends WorkEligibilityDocumentFileFormatSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The file format of the file, expressed as a file extension
         */
        public Builder value(WorkEligibilityDocumentValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The file format of the file, expressed as a file extension
         */
        public Builder value(JsonNullable<? extends WorkEligibilityDocumentValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(WorkEligibilityDocumentFileFormatSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends WorkEligibilityDocumentFileFormatSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public WorkEligibilityFileFormat build() {
            return new WorkEligibilityFileFormat(
                value,
                sourceValue);
        }
    }
}
