/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.LmsCreateCollectionRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class LmsUpdateCollectionRequest {

    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    @SpeakeasyMetadata("request:mediaType=application/json")
    private LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto;

    @JsonCreator
    public LmsUpdateCollectionRequest(
            String xAccountId,
            String id,
            LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(lmsCreateCollectionRequestDto, "lmsCreateCollectionRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.lmsCreateCollectionRequestDto = lmsCreateCollectionRequestDto;
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto() {
        return lmsCreateCollectionRequestDto;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The account identifier
     */
    public LmsUpdateCollectionRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsUpdateCollectionRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public LmsUpdateCollectionRequest withLmsCreateCollectionRequestDto(LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto) {
        Utils.checkNotNull(lmsCreateCollectionRequestDto, "lmsCreateCollectionRequestDto");
        this.lmsCreateCollectionRequestDto = lmsCreateCollectionRequestDto;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LmsUpdateCollectionRequest other = (LmsUpdateCollectionRequest) o;
        return 
            Objects.deepEquals(this.xAccountId, other.xAccountId) &&
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.lmsCreateCollectionRequestDto, other.lmsCreateCollectionRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            xAccountId,
            id,
            lmsCreateCollectionRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LmsUpdateCollectionRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "lmsCreateCollectionRequestDto", lmsCreateCollectionRequestDto);
    }
    
    public final static class Builder {
 
        private String xAccountId;
 
        private String id;
 
        private LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder lmsCreateCollectionRequestDto(LmsCreateCollectionRequestDto lmsCreateCollectionRequestDto) {
            Utils.checkNotNull(lmsCreateCollectionRequestDto, "lmsCreateCollectionRequestDto");
            this.lmsCreateCollectionRequestDto = lmsCreateCollectionRequestDto;
            return this;
        }
        
        public LmsUpdateCollectionRequest build() {
            return new LmsUpdateCollectionRequest(
                xAccountId,
                id,
                lmsCreateCollectionRequestDto);
        }
    }
}
