/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class IamUserValue {
    public static final IamUserValue ENABLED = new IamUserValue("enabled");
    public static final IamUserValue DISABLED = new IamUserValue("disabled");
    public static final IamUserValue PENDING = new IamUserValue("pending");
    public static final IamUserValue UNMAPPED_VALUE = new IamUserValue("unmapped_value");
    private static final Map<String, IamUserValue> values = IamUserValue.createValuesMap();
    private static final Map<String, IamUserValueEnum> enums = IamUserValue.createEnumsMap();
    private final String value;

    private IamUserValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IamUserValue of(String value) {
        Class<IamUserValue> clazz = IamUserValue.class;
        synchronized (IamUserValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new IamUserValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<IamUserValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IamUserValue other = (IamUserValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "IamUserValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IamUserValue[] values() {
        Class<IamUserValue> clazz = IamUserValue.class;
        synchronized (IamUserValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new IamUserValue[0]);
        }
    }

    private static final Map<String, IamUserValue> createValuesMap() {
        LinkedHashMap<String, IamUserValue> map = new LinkedHashMap<String, IamUserValue>();
        map.put("enabled", ENABLED);
        map.put("disabled", DISABLED);
        map.put("pending", PENDING);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, IamUserValueEnum> createEnumsMap() {
        HashMap<String, IamUserValueEnum> map = new HashMap<String, IamUserValueEnum>();
        map.put("enabled", IamUserValueEnum.ENABLED);
        map.put("disabled", IamUserValueEnum.DISABLED);
        map.put("pending", IamUserValueEnum.PENDING);
        map.put("unmapped_value", IamUserValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum IamUserValueEnum {
        ENABLED("enabled"),
        DISABLED("disabled"),
        PENDING("pending"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private IamUserValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<IamUserValue> {
        protected _Deserializer() {
            super(IamUserValue.class);
        }

        public IamUserValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return IamUserValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<IamUserValue> {
        protected _Serializer() {
            super(IamUserValue.class);
        }

        public void serialize(IamUserValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

