/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class WorkEligibilityValue {
    public static final WorkEligibilityValue VISA = new WorkEligibilityValue("visa");
    public static final WorkEligibilityValue PASSPORT = new WorkEligibilityValue("passport");
    public static final WorkEligibilityValue DRIVER_LICENSE = new WorkEligibilityValue("driver_license");
    public static final WorkEligibilityValue BIRTH_CERTIFICATE = new WorkEligibilityValue("birth_certificate");
    public static final WorkEligibilityValue OTHER = new WorkEligibilityValue("other");
    public static final WorkEligibilityValue UNMAPPED_VALUE = new WorkEligibilityValue("unmapped_value");
    private static final Map<String, WorkEligibilityValue> values = WorkEligibilityValue.createValuesMap();
    private static final Map<String, WorkEligibilityValueEnum> enums = WorkEligibilityValue.createEnumsMap();
    private final String value;

    private WorkEligibilityValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkEligibilityValue of(String value) {
        Class<WorkEligibilityValue> clazz = WorkEligibilityValue.class;
        synchronized (WorkEligibilityValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new WorkEligibilityValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<WorkEligibilityValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkEligibilityValue other = (WorkEligibilityValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "WorkEligibilityValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkEligibilityValue[] values() {
        Class<WorkEligibilityValue> clazz = WorkEligibilityValue.class;
        synchronized (WorkEligibilityValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new WorkEligibilityValue[0]);
        }
    }

    private static final Map<String, WorkEligibilityValue> createValuesMap() {
        LinkedHashMap<String, WorkEligibilityValue> map = new LinkedHashMap<String, WorkEligibilityValue>();
        map.put("visa", VISA);
        map.put("passport", PASSPORT);
        map.put("driver_license", DRIVER_LICENSE);
        map.put("birth_certificate", BIRTH_CERTIFICATE);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, WorkEligibilityValueEnum> createEnumsMap() {
        HashMap<String, WorkEligibilityValueEnum> map = new HashMap<String, WorkEligibilityValueEnum>();
        map.put("visa", WorkEligibilityValueEnum.VISA);
        map.put("passport", WorkEligibilityValueEnum.PASSPORT);
        map.put("driver_license", WorkEligibilityValueEnum.DRIVER_LICENSE);
        map.put("birth_certificate", WorkEligibilityValueEnum.BIRTH_CERTIFICATE);
        map.put("other", WorkEligibilityValueEnum.OTHER);
        map.put("unmapped_value", WorkEligibilityValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum WorkEligibilityValueEnum {
        VISA("visa"),
        PASSPORT("passport"),
        DRIVER_LICENSE("driver_license"),
        BIRTH_CERTIFICATE("birth_certificate"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private WorkEligibilityValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<WorkEligibilityValue> {
        protected _Deserializer() {
            super(WorkEligibilityValue.class);
        }

        public WorkEligibilityValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return WorkEligibilityValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<WorkEligibilityValue> {
        protected _Serializer() {
            super(WorkEligibilityValue.class);
        }

        public void serialize(WorkEligibilityValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

