/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ApplicationsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class AtsListApplicationsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ApplicationsPaginated> applicationsPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<AtsListApplicationsResponse>> next = () -> Optional.empty();

    @JsonCreator
    public AtsListApplicationsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ApplicationsPaginated> applicationsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(applicationsPaginated, "applicationsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.applicationsPaginated = applicationsPaginated;
        this.headers = headers;
    }

    public AtsListApplicationsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ApplicationsPaginated> applicationsPaginated() {
        return this.applicationsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<AtsListApplicationsResponse> next() throws Exception {
        return this.next.call();
    }

    private AtsListApplicationsResponse withNext(Callable<Optional<AtsListApplicationsResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsListApplicationsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListApplicationsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListApplicationsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListApplicationsResponse withApplicationsPaginated(ApplicationsPaginated applicationsPaginated) {
        Utils.checkNotNull(applicationsPaginated, "applicationsPaginated");
        this.applicationsPaginated = Optional.ofNullable(applicationsPaginated);
        return this;
    }

    public AtsListApplicationsResponse withApplicationsPaginated(Optional<? extends ApplicationsPaginated> applicationsPaginated) {
        Utils.checkNotNull(applicationsPaginated, "applicationsPaginated");
        this.applicationsPaginated = applicationsPaginated;
        return this;
    }

    public AtsListApplicationsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListApplicationsResponse other = (AtsListApplicationsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.applicationsPaginated, other.applicationsPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.applicationsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListApplicationsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "applicationsPaginated", this.applicationsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<AtsListApplicationsResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ApplicationsPaginated> applicationsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder applicationsPaginated(ApplicationsPaginated applicationsPaginated) {
            Utils.checkNotNull(applicationsPaginated, "applicationsPaginated");
            this.applicationsPaginated = Optional.ofNullable(applicationsPaginated);
            return this;
        }

        public Builder applicationsPaginated(Optional<? extends ApplicationsPaginated> applicationsPaginated) {
            Utils.checkNotNull(applicationsPaginated, "applicationsPaginated");
            this.applicationsPaginated = applicationsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<AtsListApplicationsResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public AtsListApplicationsResponse build() {
            return new AtsListApplicationsResponse(this.contentType, this.statusCode, this.rawResponse, this.applicationsPaginated, this.headers).withNext(this.next);
        }
    }
}

