/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.components.LmsCreateContentRequestDto;
import com.stackone.stackone_client_java.models.operations.LmsUpdateContentResponse;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class LmsUpdateContentRequestBuilder {
    private String xAccountId;
    private String id;
    private LmsCreateContentRequestDto lmsCreateContentRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallLmsUpdateContent sdk;

    public LmsUpdateContentRequestBuilder(SDKMethodInterfaces.MethodCallLmsUpdateContent sdk) {
        this.sdk = sdk;
    }

    public LmsUpdateContentRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsUpdateContentRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public LmsUpdateContentRequestBuilder lmsCreateContentRequestDto(LmsCreateContentRequestDto lmsCreateContentRequestDto) {
        Utils.checkNotNull(lmsCreateContentRequestDto, "lmsCreateContentRequestDto");
        this.lmsCreateContentRequestDto = lmsCreateContentRequestDto;
        return this;
    }

    public LmsUpdateContentRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsUpdateContentRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public LmsUpdateContentResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.updateContent(this.xAccountId, this.id, this.lmsCreateContentRequestDto, options);
    }
}

