/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class EmploymentWorkTimeValue {
    public static final EmploymentWorkTimeValue DAY = new EmploymentWorkTimeValue("day");
    public static final EmploymentWorkTimeValue WEEK = new EmploymentWorkTimeValue("week");
    public static final EmploymentWorkTimeValue MONTH = new EmploymentWorkTimeValue("month");
    public static final EmploymentWorkTimeValue YEAR = new EmploymentWorkTimeValue("year");
    public static final EmploymentWorkTimeValue UNMAPPED_VALUE = new EmploymentWorkTimeValue("unmapped_value");
    private static final Map<String, EmploymentWorkTimeValue> values = EmploymentWorkTimeValue.createValuesMap();
    private static final Map<String, EmploymentWorkTimeValueEnum> enums = EmploymentWorkTimeValue.createEnumsMap();
    private final String value;

    private EmploymentWorkTimeValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentWorkTimeValue of(String value) {
        Class<EmploymentWorkTimeValue> clazz = EmploymentWorkTimeValue.class;
        synchronized (EmploymentWorkTimeValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmploymentWorkTimeValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<EmploymentWorkTimeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmploymentWorkTimeValue other = (EmploymentWorkTimeValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmploymentWorkTimeValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentWorkTimeValue[] values() {
        Class<EmploymentWorkTimeValue> clazz = EmploymentWorkTimeValue.class;
        synchronized (EmploymentWorkTimeValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmploymentWorkTimeValue[0]);
        }
    }

    private static final Map<String, EmploymentWorkTimeValue> createValuesMap() {
        LinkedHashMap<String, EmploymentWorkTimeValue> map = new LinkedHashMap<String, EmploymentWorkTimeValue>();
        map.put("day", DAY);
        map.put("week", WEEK);
        map.put("month", MONTH);
        map.put("year", YEAR);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, EmploymentWorkTimeValueEnum> createEnumsMap() {
        HashMap<String, EmploymentWorkTimeValueEnum> map = new HashMap<String, EmploymentWorkTimeValueEnum>();
        map.put("day", EmploymentWorkTimeValueEnum.DAY);
        map.put("week", EmploymentWorkTimeValueEnum.WEEK);
        map.put("month", EmploymentWorkTimeValueEnum.MONTH);
        map.put("year", EmploymentWorkTimeValueEnum.YEAR);
        map.put("unmapped_value", EmploymentWorkTimeValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum EmploymentWorkTimeValueEnum {
        DAY("day"),
        WEEK("week"),
        MONTH("month"),
        YEAR("year"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private EmploymentWorkTimeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<EmploymentWorkTimeValue> {
        protected _Deserializer() {
            super(EmploymentWorkTimeValue.class);
        }

        public EmploymentWorkTimeValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return EmploymentWorkTimeValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<EmploymentWorkTimeValue> {
        protected _Serializer() {
            super(EmploymentWorkTimeValue.class);
        }

        public void serialize(EmploymentWorkTimeValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

