/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.UnifiedUploadRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;

public class AtsUploadApplicationDocumentRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private UnifiedUploadRequestDto unifiedUploadRequestDto;

    @JsonCreator
    public AtsUploadApplicationDocumentRequest(String xAccountId, String id, UnifiedUploadRequestDto unifiedUploadRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.unifiedUploadRequestDto = unifiedUploadRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public UnifiedUploadRequestDto unifiedUploadRequestDto() {
        return this.unifiedUploadRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsUploadApplicationDocumentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUploadApplicationDocumentRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUploadApplicationDocumentRequest withUnifiedUploadRequestDto(UnifiedUploadRequestDto unifiedUploadRequestDto) {
        Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
        this.unifiedUploadRequestDto = unifiedUploadRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsUploadApplicationDocumentRequest other = (AtsUploadApplicationDocumentRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.unifiedUploadRequestDto, other.unifiedUploadRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.unifiedUploadRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsUploadApplicationDocumentRequest.class, "xAccountId", this.xAccountId, "id", this.id, "unifiedUploadRequestDto", this.unifiedUploadRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private UnifiedUploadRequestDto unifiedUploadRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder unifiedUploadRequestDto(UnifiedUploadRequestDto unifiedUploadRequestDto) {
            Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
            this.unifiedUploadRequestDto = unifiedUploadRequestDto;
            return this;
        }

        public AtsUploadApplicationDocumentRequest build() {
            return new AtsUploadApplicationDocumentRequest(this.xAccountId, this.id, this.unifiedUploadRequestDto);
        }
    }
}

