/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * ApplicationChangesDataModelValue
 * 
 * <p>The status of the application.
 */
@JsonDeserialize(using = ApplicationChangesDataModelValue._Deserializer.class)
@JsonSerialize(using = ApplicationChangesDataModelValue._Serializer.class)
public class ApplicationChangesDataModelValue {

    public static final ApplicationChangesDataModelValue ACTIVE = new ApplicationChangesDataModelValue("active");
    public static final ApplicationChangesDataModelValue ASSESSMENT = new ApplicationChangesDataModelValue("assessment");
    public static final ApplicationChangesDataModelValue BACKGROUND_CHECK = new ApplicationChangesDataModelValue("background_check");
    public static final ApplicationChangesDataModelValue CONVERTED = new ApplicationChangesDataModelValue("converted");
    public static final ApplicationChangesDataModelValue DECLINED_BY_CANDIDATE = new ApplicationChangesDataModelValue("declined_by_candidate");
    public static final ApplicationChangesDataModelValue HIRED = new ApplicationChangesDataModelValue("hired");
    public static final ApplicationChangesDataModelValue INTERVIEW = new ApplicationChangesDataModelValue("interview");
    public static final ApplicationChangesDataModelValue LEAD = new ApplicationChangesDataModelValue("lead");
    public static final ApplicationChangesDataModelValue OFFER = new ApplicationChangesDataModelValue("offer");
    public static final ApplicationChangesDataModelValue REFERENCE_CHECK = new ApplicationChangesDataModelValue("reference_check");
    public static final ApplicationChangesDataModelValue REJECTED = new ApplicationChangesDataModelValue("rejected");
    public static final ApplicationChangesDataModelValue REVIEW = new ApplicationChangesDataModelValue("review");
    public static final ApplicationChangesDataModelValue SCREEN = new ApplicationChangesDataModelValue("screen");
    public static final ApplicationChangesDataModelValue NEW = new ApplicationChangesDataModelValue("new");
    public static final ApplicationChangesDataModelValue ONBOARDING = new ApplicationChangesDataModelValue("onboarding");
    public static final ApplicationChangesDataModelValue CREATED = new ApplicationChangesDataModelValue("created");
    public static final ApplicationChangesDataModelValue ACCEPTED = new ApplicationChangesDataModelValue("accepted");
    public static final ApplicationChangesDataModelValue SHORT_LIST = new ApplicationChangesDataModelValue("short_list");
    public static final ApplicationChangesDataModelValue APPROVED = new ApplicationChangesDataModelValue("approved");
    public static final ApplicationChangesDataModelValue UNMAPPED_VALUE = new ApplicationChangesDataModelValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, ApplicationChangesDataModelValue> values = createValuesMap();
    private static final Map<String, ApplicationChangesDataModelValueEnum> enums = createEnumsMap();

    private final String value;

    private ApplicationChangesDataModelValue(String value) {
        this.value = value;
    }

    /**
     * Returns a ApplicationChangesDataModelValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as ApplicationChangesDataModelValue
     */ 
    public static ApplicationChangesDataModelValue of(String value) {
        synchronized (ApplicationChangesDataModelValue.class) {
            return values.computeIfAbsent(value, v -> new ApplicationChangesDataModelValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<ApplicationChangesDataModelValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ApplicationChangesDataModelValue other = (ApplicationChangesDataModelValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "ApplicationChangesDataModelValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static ApplicationChangesDataModelValue[] values() {
        synchronized (ApplicationChangesDataModelValue.class) {
            return values.values().toArray(new ApplicationChangesDataModelValue[] {});
        }
    }

    private static final Map<String, ApplicationChangesDataModelValue> createValuesMap() {
        Map<String, ApplicationChangesDataModelValue> map = new LinkedHashMap<>();
        map.put("active", ACTIVE);
        map.put("assessment", ASSESSMENT);
        map.put("background_check", BACKGROUND_CHECK);
        map.put("converted", CONVERTED);
        map.put("declined_by_candidate", DECLINED_BY_CANDIDATE);
        map.put("hired", HIRED);
        map.put("interview", INTERVIEW);
        map.put("lead", LEAD);
        map.put("offer", OFFER);
        map.put("reference_check", REFERENCE_CHECK);
        map.put("rejected", REJECTED);
        map.put("review", REVIEW);
        map.put("screen", SCREEN);
        map.put("new", NEW);
        map.put("onboarding", ONBOARDING);
        map.put("created", CREATED);
        map.put("accepted", ACCEPTED);
        map.put("short_list", SHORT_LIST);
        map.put("approved", APPROVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ApplicationChangesDataModelValueEnum> createEnumsMap() {
        Map<String, ApplicationChangesDataModelValueEnum> map = new HashMap<>();
        map.put("active", ApplicationChangesDataModelValueEnum.ACTIVE);
        map.put("assessment", ApplicationChangesDataModelValueEnum.ASSESSMENT);
        map.put("background_check", ApplicationChangesDataModelValueEnum.BACKGROUND_CHECK);
        map.put("converted", ApplicationChangesDataModelValueEnum.CONVERTED);
        map.put("declined_by_candidate", ApplicationChangesDataModelValueEnum.DECLINED_BY_CANDIDATE);
        map.put("hired", ApplicationChangesDataModelValueEnum.HIRED);
        map.put("interview", ApplicationChangesDataModelValueEnum.INTERVIEW);
        map.put("lead", ApplicationChangesDataModelValueEnum.LEAD);
        map.put("offer", ApplicationChangesDataModelValueEnum.OFFER);
        map.put("reference_check", ApplicationChangesDataModelValueEnum.REFERENCE_CHECK);
        map.put("rejected", ApplicationChangesDataModelValueEnum.REJECTED);
        map.put("review", ApplicationChangesDataModelValueEnum.REVIEW);
        map.put("screen", ApplicationChangesDataModelValueEnum.SCREEN);
        map.put("new", ApplicationChangesDataModelValueEnum.NEW);
        map.put("onboarding", ApplicationChangesDataModelValueEnum.ONBOARDING);
        map.put("created", ApplicationChangesDataModelValueEnum.CREATED);
        map.put("accepted", ApplicationChangesDataModelValueEnum.ACCEPTED);
        map.put("short_list", ApplicationChangesDataModelValueEnum.SHORT_LIST);
        map.put("approved", ApplicationChangesDataModelValueEnum.APPROVED);
        map.put("unmapped_value", ApplicationChangesDataModelValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<ApplicationChangesDataModelValue> {

        protected _Serializer() {
            super(ApplicationChangesDataModelValue.class);
        }

        @Override
        public void serialize(ApplicationChangesDataModelValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<ApplicationChangesDataModelValue> {

        protected _Deserializer() {
            super(ApplicationChangesDataModelValue.class);
        }

        @Override
        public ApplicationChangesDataModelValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return ApplicationChangesDataModelValue.of(v);
        }
    }
    
    public enum ApplicationChangesDataModelValueEnum {

        ACTIVE("active"),
        ASSESSMENT("assessment"),
        BACKGROUND_CHECK("background_check"),
        CONVERTED("converted"),
        DECLINED_BY_CANDIDATE("declined_by_candidate"),
        HIRED("hired"),
        INTERVIEW("interview"),
        LEAD("lead"),
        OFFER("offer"),
        REFERENCE_CHECK("reference_check"),
        REJECTED("rejected"),
        REVIEW("review"),
        SCREEN("screen"),
        NEW("new"),
        ONBOARDING("onboarding"),
        CREATED("created"),
        ACCEPTED("accepted"),
        SHORT_LIST("short_list"),
        APPROVED("approved"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private ApplicationChangesDataModelValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

