/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils.pagination;

import com.jayway.jsonpath.ReadContext;

import static com.stackone.stackone_client_java.utils.Utils.castLong;

// Internal API only

/**
 * Handles pagination using a results expression to determine termination.
 * This tracker is suitable for APIs that return a count of items in each response
 * and use that to determine if there are more pages, while maintaining monotonic
 * page number increments.
 *
 * @param <ProgressParamT> The numeric type to use for page numbers (e.g., Integer, Long)
 */
public class ResultsPageTracker<ProgressParamT extends Number> implements ProgressTrackerStrategy<ProgressParamT> {
    private final String resultSizeExpression;
    private final long minItems;
    private final Class<ProgressParamT> pageType;

    private long currentPage;

    /**
     * Creates a new ResultsExpressionPageTracker with a specified starting page.
     *
     * @param resultSizeExpression The JsonPath expression to extract result count
     * @param pageType            The class of the numeric type to use (e.g., Integer.class, Long.class)
     * @param fromPage            Page number to start pagination from (0-based or 1-based, depending on API)
     * @param minItems            Minimum number of items required to continue pagination
     */
    public ResultsPageTracker(
            String resultSizeExpression,
            Class<ProgressParamT> pageType,
            long fromPage,
            long minItems) {
        this.resultSizeExpression = resultSizeExpression;
        this.pageType = pageType;
        this.currentPage = fromPage;
        this.minItems = minItems;
    }

    @Override
    public boolean advance(ReadContext respJson) {
        Long numItems = respJson.read(resultSizeExpression, Long.class);
        if (numItems == null) {
            numItems = 0L;
        }

        if (numItems < minItems) {
            return false;
        }

        currentPage++;
        return true;
    }

    @Override
    public ProgressParamT getPosition() {
        return castLong(currentPage, pageType);
    }
}