/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.AccountingListCompanyJournalsRequest;
import com.stackone.stackone_client_java.models.operations.AccountingListCompanyJournalsResponse;
import com.stackone.stackone_client_java.operations.AccountingListCompanyJournals;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class AccountingListCompanyJournalsRequestBuilder {
    private AccountingListCompanyJournalsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public AccountingListCompanyJournalsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AccountingListCompanyJournalsRequestBuilder request(AccountingListCompanyJournalsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public AccountingListCompanyJournalsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AccountingListCompanyJournalsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public AccountingListCompanyJournalsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AccountingListCompanyJournals.Sync operation = new AccountingListCompanyJournals.Sync(this.sdkConfiguration, options);
        return (AccountingListCompanyJournalsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<AccountingListCompanyJournalsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AccountingListCompanyJournals.Sync operation = new AccountingListCompanyJournals.Sync(this.sdkConfiguration, options);
        Paginator<AccountingListCompanyJournalsRequest, String> iterator = new Paginator<AccountingListCompanyJournalsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), AccountingListCompanyJournalsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<AccountingListCompanyJournalsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

