/*
 * Decompiled with CFR 0.152.
 */
package com.stateforge.statebuilder.java;

import com.stateforge.statebuilder.StateBuilderException;
import com.stateforge.statebuilder.java.CoderBaseJava;
import com.stateforge.statebuilder.model.ObjectType;
import com.stateforge.statebuilder.model.State;
import com.stateforge.statebuilder.model.StateMachineModel;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;

public class CoderParallel
extends CoderBaseJava {
    public CoderParallel(StateMachineModel model, JCodeModel code) {
        super(model, code);
    }

    public void code() throws StateBuilderException {
        try {
            this.writeClass(this.getModel().getStateMachine().getState());
        }
        catch (Exception e) {
            throw new StateBuilderException((Throwable)e);
        }
    }

    private void writeClass(State state) throws JClassAlreadyExistsException, StateBuilderException {
        for (State stateParallel : state.getParallelList()) {
            String parallelClassName = this.getModel().getStateMachine().getSettings().getNamespace() + "." + this.getParallelClassName(stateParallel);
            JDefinedClass parallelClass = this.getCode()._class(parallelClassName);
            parallelClass.javadoc().add((Object)("Parallel class " + parallelClassName));
            parallelClass._extends(this.getCode().directClass("com.stateforge.statemachine.context.ContextParallel"));
            JMethod constructor = parallelClass.constructor(1);
            JFieldVar contextField = parallelClass.field(4, (JType)this.getCode().directClass(this.getContextClassName(state)), this.getModel().getContextInstance());
            JVar contextParam = constructor.param((JType)this.getCode().directClass(this.getContextClassName(state)), this.getModel().getContextInstance() + "ToSet");
            JBlock blockContructor = constructor.body();
            blockContructor.assign((JAssignmentTarget)contextField, (JExpression)contextParam);
            for (State stateOrthogonal : stateParallel.getParallel().getState()) {
                String contextVarName = "my" + this.getContextClassName(stateOrthogonal);
                JClass contextOrthognalClass = this.getCode().directClass(this.getContextClassName(stateOrthogonal));
                JFieldVar contextOrthogonalField = parallelClass.field(4, (JType)contextOrthognalClass, contextVarName);
                JInvocation contextOrthogonalInvokation = JExpr._new((JClass)contextOrthognalClass);
                for (ObjectType obj : this.getModel().getStateMachine().getSettings().getObject()) {
                    contextOrthogonalInvokation = contextOrthogonalInvokation.arg((JExpression)JExpr.ref((String)obj.getInstance()));
                }
                contextOrthogonalInvokation = contextOrthogonalInvokation.arg((JExpression)contextParam);
                blockContructor.assign((JAssignmentTarget)contextOrthogonalField, (JExpression)contextOrthogonalInvokation);
                JMethod getter = parallelClass.method(1, (JType)this.getCode().directClass(this.getContextClassName(stateOrthogonal)), "get" + this.getContextClassName(stateOrthogonal));
                getter.body()._return((JExpression)contextOrthogonalField);
            }
            for (ObjectType obj : this.getModel().getStateMachine().getSettings().getObject()) {
                String objFullClassName = !obj.getInclude().isEmpty() ? obj.getInclude() + "." + obj.getClazz() : obj.getClazz();
                constructor.param((JType)this.getCode().directClass(objFullClassName), obj.getInstance());
            }
            this.writeTransitionToNextState(state, stateParallel, parallelClass);
        }
        if (state.getParallel() != null) {
            for (State stateOrthogonal : state.getParallel().getState()) {
                this.writeClass(stateOrthogonal);
            }
        }
        for (State stateChild : state.getState()) {
            this.writeClass(stateChild);
        }
    }

    private void writeTransitionToNextState(State state, State stateParallel, JDefinedClass parallelClass) throws StateBuilderException {
        JMethod transitionToNextState = parallelClass.method(1, Void.TYPE, "transitionToNextState");
        transitionToNextState.javadoc().add((Object)"Transition to next the next");
        JBlock block = transitionToNextState.body();
        State stateNext = this.getModel().getState(stateParallel.getParallel().getNextState());
        this.writeProcessTransition(state, stateNext, block, "Begin");
        this.writeProcessTransition(state, stateNext, block, "End");
        this.writeContextOnEnd(stateParallel, stateNext, block);
    }
}

