/*
 * Decompiled with CFR 0.152.
 */
package com.stimulussoft.filequeue;

import com.google.common.annotations.VisibleForTesting;
import com.stimulussoft.filequeue.FileQueueItem;
import com.stimulussoft.filequeue.QueueCallback;
import com.stimulussoft.filequeue.processor.Consumer;
import com.stimulussoft.filequeue.processor.Expiration;
import com.stimulussoft.filequeue.processor.QueueProcessor;
import com.stimulussoft.util.AdjustableSemaphore;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FileQueue<T> {
    private ShutdownHook shutdownHook;
    private final AtomicBoolean isStarted = new AtomicBoolean();
    private final AdjustableSemaphore permits = new AdjustableSemaphore();
    private QueueProcessor<T> transferQueue;
    private Config config;
    private final Consumer<T> fileQueueConsumer = item -> {
        Consumer.Result result = this.config.getConsumer().consume(item);
        if (result != Consumer.Result.FAIL_REQUEUE) {
            this.permits.release();
        }
        return result;
    };

    public synchronized void startQueue(Config config) throws IOException, IllegalStateException, IllegalArgumentException, InterruptedException {
        if (this.isStarted.get()) {
            throw new IllegalStateException("already started");
        }
        this.config = config;
        this.transferQueue = config.builder.consumer(this.fileQueueConsumer).build();
        this.permits.setMaxPermits(config.maxQueueSize);
        int i = 0;
        while ((long)i < this.transferQueue.size() && this.permits.tryAcquire()) {
            ++i;
        }
        this.shutdownHook = new ShutdownHook();
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.isStarted.set(true);
    }

    public Config getConfig() throws IllegalStateException {
        if (!this.isStarted.get()) {
            throw new IllegalStateException("already started");
        }
        return this.config;
    }

    public synchronized void stopQueue() {
        if (this.isStarted.compareAndSet(true, false)) {
            try {
                this.transferQueue.close();
            }
            finally {
                this.permits.release(this.permits.drainPermits());
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
    }

    public static Config config(String queueName, Path queuePath, Class type, Consumer consumer) {
        return new Config(queueName, queuePath, type, consumer);
    }

    @VisibleForTesting
    public void queueItem(T fileQueueItem, QueueCallback queueCallback, int acquireWait, TimeUnit acquireWaitUnit) throws Exception {
        this.acquirePermit(acquireWait, acquireWaitUnit);
        try {
            queueCallback.availableSlot(fileQueueItem);
            this._queueItem(fileQueueItem);
        }
        catch (InterruptedException ie) {
            this.permits.release();
            throw ie;
        }
        catch (Exception io) {
            this.permits.release();
            throw io;
        }
    }

    public void queueItem(T fileQueueItem, int acquireWait, TimeUnit acquireWaitUnit) throws IOException, InterruptedException, IllegalArgumentException {
        this.acquirePermit(acquireWait, acquireWaitUnit);
        try {
            this.queueItem(fileQueueItem);
        }
        catch (Exception io) {
            this.permits.release();
            throw io;
        }
    }

    public void queueItem(T fileQueueItem) throws IOException, IllegalArgumentException, IllegalStateException {
        this._queueItem(fileQueueItem);
    }

    private void _queueItem(T fileQueueItem) throws IOException, IllegalArgumentException, IllegalStateException {
        if (fileQueueItem == null) {
            throw new IllegalArgumentException("filequeue item cannot be null");
        }
        if (!this.isStarted.get()) {
            throw new IllegalStateException("queue not started");
        }
        try {
            this.transferQueue.submit(fileQueueItem);
        }
        catch (NullPointerException npe) {
            throw new IOException("not enough disk space");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public long getQueueSize() throws IllegalStateException {
        if (!this.isStarted.get()) {
            throw new IllegalStateException("queue not started");
        }
        return this.transferQueue.size();
    }

    public void setMaxQueueSize(int queueSize) {
        if (this.config != null) {
            this.config = this.config.maxQueueSize(queueSize);
        }
        this.permits.setMaxPermits(queueSize);
    }

    private void acquirePermit(int acquireWait, TimeUnit acquireWaitUnit) throws IOException, InterruptedException {
        if (!this.isStarted.get()) {
            throw new IllegalStateException("queue not started");
        }
        if (!this.permits.tryAcquire(acquireWait, acquireWaitUnit)) {
            throw new IOException("filequeue " + this.transferQueue.getQueuePath() + " is full. {maxQueueSize='" + this.config.maxQueueSize + "'}");
        }
    }

    public long getNoQueueItems() {
        return this.transferQueue.size();
    }

    public static void destroy() {
        QueueProcessor.destroy();
    }

    public static FileQueue<FileQueueItem> fileQueue() {
        return new FileQueue<FileQueueItem>();
    }

    protected int availablePermits() {
        return this.permits.availablePermits();
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            FileQueue.this.shutdownHook = null;
            try {
                FileQueue.this.stopQueue();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static class Config<T> {
        private int maxQueueSize = Integer.MAX_VALUE;
        private Consumer consumer;
        private QueueProcessor.Builder builder = QueueProcessor.builder();

        public Config(String queueName, Path queuePath, Class type, Consumer consumer) {
            this.builder = this.builder.type(type).queueName(queueName).queuePath(queuePath);
            this.consumer = consumer;
        }

        public Config() {
        }

        public Config queuePath(Path queuePath) {
            this.builder = this.builder.queuePath(queuePath);
            return this;
        }

        public Path getQueuePath() {
            return this.builder.getQueuePath();
        }

        public Config queueName(String queueName) {
            this.builder = this.builder.queueName(queueName);
            return this;
        }

        public String getQueueName() {
            return this.builder.getQueueName();
        }

        public Config type(Class type) throws IllegalArgumentException {
            if (type == FileQueueItem.class || !FileQueueItem.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException("type must be a subclass of filequeueitem");
            }
            this.builder = this.builder.type(type);
            return this;
        }

        public Class getType() {
            return this.builder.getType();
        }

        public Config maxTries(int maxTries) {
            this.builder = this.builder.maxTries(maxTries);
            return this;
        }

        public int getMaxTries() {
            return this.builder.getMaxTries();
        }

        public Config retryDelay(int retryDelay) {
            this.builder = this.builder.retryDelay(retryDelay);
            return this;
        }

        public int getRetryDelay() {
            return this.builder.getRetryDelay();
        }

        public Config persistRetryDelay(int retryDelay) {
            this.builder = this.builder.persistRetryDelay(retryDelay);
            return this;
        }

        public int getPersistRetryDelay() {
            return this.builder.getPersistRetryDelay();
        }

        public Config persistRetryDelayUnit(TimeUnit persistRetryDelayUnit) {
            this.builder = this.builder.persistRetryDelayUnit(persistRetryDelayUnit);
            return this;
        }

        public TimeUnit getPersistRetryDelayUnit() {
            return this.builder.getPersistRetryDelayUnit();
        }

        public Config maxRetryDelay(int maxRetryDelay) {
            this.builder = this.builder.maxRetryDelay(maxRetryDelay);
            return this;
        }

        public int getMaxRetryDelay() {
            return this.builder.getMaxRetryDelay();
        }

        public Config retryDelayUnit(TimeUnit retryDelayUnit) {
            this.builder = this.builder.retryDelayUnit(retryDelayUnit);
            return this;
        }

        public TimeUnit getRetryDelayUnit() {
            return this.builder.getRetryDelayUnit();
        }

        public Config retryDelayAlgorithm(RetryDelayAlgorithm retryDelayAlgorithm) {
            this.builder = this.builder.retryDelayAlgorithm(QueueProcessor.RetryDelayAlgorithm.valueOf(retryDelayAlgorithm.name()));
            return this;
        }

        public RetryDelayAlgorithm getRetryDelayAlgorithm() {
            return RetryDelayAlgorithm.valueOf(this.builder.getRetryDelayAlgorithm().name());
        }

        public Config consumer(Consumer<T> consumer) {
            this.consumer = consumer;
            return this;
        }

        public Consumer getConsumer() {
            return this.consumer;
        }

        public Config expiration(Expiration<T> expiration) {
            this.builder = this.builder.expiration(expiration);
            return this;
        }

        public Expiration getExpiration() {
            return this.builder.getExpiration();
        }

        public Config maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }
    }

    public static enum RetryDelayAlgorithm {
        FIXED,
        EXPONENTIAL;

    }
}

