/*
 * Decompiled with CFR 0.152.
 */
package com.stimulussoft.filequeue;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class FileQueueItem
implements Serializable {
    private AtomicInteger retryCount = new AtomicInteger(0);
    private Date tryDate;

    public Date getTryDate() {
        return new Date(this.tryDate.getTime());
    }

    public void setTryDate(Date date) {
        this.tryDate = new Date(date.getTime());
    }

    public int getTryCount() {
        return this.retryCount.get();
    }

    public void setTryCount(int tryCount) {
        Preconditions.checkArgument((tryCount >= 0 ? 1 : 0) != 0, (Object)"tryCount can't be less 0");
        this.retryCount.set(tryCount);
    }

    public void incTryCount() {
        this.retryCount.incrementAndGet();
    }

    public abstract String toString();
}

