/*
 * Decompiled with CFR 0.152.
 */
package com.stimulussoft.filequeue.store;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.store.fs.FilePath;

public class MVStoreQueue
implements Comparable<MVStoreQueue> {
    private final String queueName;
    private MVMap<Integer, byte[]> mvMap;
    private MVStore store;
    private Path queueDir;
    private final AtomicInteger tailKey = new AtomicInteger(0);

    public MVStoreQueue(Path queueDir, String queueName) throws IOException {
        Files.createDirectories(queueDir, new FileAttribute[0]);
        this.queueDir = queueDir.toAbsolutePath();
        this.queueName = queueName;
        this.reopen();
    }

    private Path getDBName() {
        return this.queueDir.resolve(this.queueName);
    }

    public synchronized void reopen() throws IllegalStateException {
        try {
            if (this.store != null && !this.store.isClosed()) {
                this.store.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.store = this.getOpenStore();
        this.mvMap = this.store.openMap(this.queueName);
        if (!this.mvMap.isEmpty()) {
            this.tailKey.set((Integer)this.mvMap.lastKey());
        }
    }

    private MVStore getOpenStore() {
        Path dbName = this.getDBName();
        String path = dbName.toUri().getScheme().equals("jimfs") ? dbName.toUri().toString() : dbName.toString();
        return new MVStore.Builder().fileName(path).cacheSize(1).autoCommitDisabled().open();
    }

    public Path getQueueDir() {
        return this.queueDir;
    }

    public synchronized byte[] poll() {
        if (this.mvMap.isEmpty()) {
            this.tailKey.set(0);
            return null;
        }
        return (byte[])this.mvMap.remove(this.mvMap.firstKey());
    }

    public synchronized void push(byte[] element) {
        Preconditions.checkNotNull((Object)element, (Object)"cant insert null");
        this.mvMap.put((Object)this.tailKey.incrementAndGet(), (Object)element);
    }

    public void clear() {
        this.mvMap.clear();
    }

    public long size() {
        return this.mvMap.size();
    }

    public boolean isEmpty() {
        return this.mvMap.isEmpty();
    }

    public synchronized void close() {
        this.store.sync();
        this.store.close();
    }

    @Override
    public int compareTo(@Nonnull MVStoreQueue o) {
        int result = (int)(this.size() - o.size());
        return Integer.compare(result, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MVStoreQueue)) {
            return false;
        }
        MVStoreQueue that = (MVStoreQueue)o;
        if (!this.queueName.equals(that.queueName)) {
            return false;
        }
        if (!this.store.equals(that.store)) {
            return false;
        }
        return this.getQueueDir().equals(that.getQueueDir());
    }

    public int hashCode() {
        int result = this.queueName.hashCode();
        result = 31 * result + this.store.hashCode();
        result = 31 * result + this.getQueueDir().hashCode();
        return result;
    }

    public void commit() {
        this.store.commit();
    }

    static {
        FilePath.register((FilePath)new JimFSDecorator());
    }

    private static class JimFSDecorator
    extends FilePath {
        private Path decorated;

        public JimFSDecorator() {
        }

        private JimFSDecorator(Path path) {
            this.name = path.toString();
            this.decorated = path;
        }

        public long size() {
            try {
                return Files.size(this.decorated);
            }
            catch (IOException e) {
                throw DbException.get((int)90028, (String[])new String[]{this.name, e.getMessage()});
            }
        }

        public void moveTo(FilePath filePath, boolean b) {
            System.out.println(this.name);
            System.out.println(filePath);
        }

        public boolean createFile() {
            try {
                Files.createFile(this.decorated, new FileAttribute[0]);
                return Files.exists(this.decorated, new LinkOption[0]);
            }
            catch (IOException e) {
                throw DbException.get((int)90028, (String[])new String[]{this.name, e.getMessage()});
            }
        }

        public boolean exists() {
            return Files.exists(this.decorated, new LinkOption[0]);
        }

        public void delete() {
            try {
                Files.deleteIfExists(this.decorated);
            }
            catch (IOException e) {
                throw DbException.get((int)90028, (String[])new String[]{this.name, e.getMessage()});
            }
        }

        public List<FilePath> newDirectoryStream() {
            try {
                return Files.walk(this.decorated, new FileVisitOption[0]).map(JimFSDecorator::new).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw DbException.get((int)90028, (String[])new String[]{this.name, e.getMessage()});
            }
        }

        public FilePath toRealPath() {
            return this.getPath(this.decorated);
        }

        public FilePath getParent() {
            Path parent = this.decorated.getParent();
            return parent == null ? null : this.getPath(parent);
        }

        public boolean isDirectory() {
            return Files.isDirectory(this.decorated, new LinkOption[0]);
        }

        public boolean isAbsolute() {
            return this.decorated.toFile().isAbsolute();
        }

        public long lastModified() {
            try {
                return Files.getLastModifiedTime(this.decorated, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                throw DbException.get((int)90028, (String[])new String[]{this.name, e.getMessage()});
            }
        }

        public boolean canWrite() {
            return Files.isWritable(this.decorated);
        }

        public void createDirectory() {
            try {
                Files.createDirectories(this.decorated, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw DbException.get((int)90028, (String[])new String[]{this.name, e.getMessage()});
            }
        }

        public OutputStream newOutputStream(boolean append) throws IOException {
            return append ? Files.newOutputStream(this.decorated, StandardOpenOption.APPEND) : Files.newOutputStream(this.decorated, new OpenOption[0]);
        }

        public FileChannel open(String s) throws IOException {
            try {
                Files.createFile(this.decorated, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            if ("r".equalsIgnoreCase(s)) {
                return FileChannel.open(this.decorated, StandardOpenOption.READ);
            }
            return FileChannel.open(this.decorated, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }

        public InputStream newInputStream() throws IOException {
            return Files.newInputStream(this.decorated, new OpenOption[0]);
        }

        public boolean setReadOnly() {
            return this.decorated.toFile().setReadOnly();
        }

        public String getScheme() {
            return "jimfs";
        }

        public FilePath getPath(String path) {
            try {
                URI uri = new URI(path);
                if (!uri.getScheme().equalsIgnoreCase(this.getScheme())) {
                    throw DbException.get((int)90028, (String[])new String[]{this.name, uri.getScheme() + " not exists"});
                }
                return new JimFSDecorator(Paths.get(uri));
            }
            catch (URISyntaxException e) {
                throw DbException.get((int)90028, (String[])new String[]{this.name, e.getMessage()});
            }
        }

        private FilePath getPath(Path path) {
            return new JimFSDecorator(path);
        }
    }
}

