/*
 * Decompiled with CFR 0.152.
 */
package com.stimulussoft.util;

import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadUtil {
    public static final int DEFAULT_CORE_POOL_SIZE = 1;

    public static ThreadFactory getFlexibleThreadFactory(String name) {
        return new FlexibleThreadFactory(name, false);
    }

    public static ThreadFactory getFlexibleThreadFactory(String name, boolean daemon) {
        return new FlexibleThreadFactory(name, daemon);
    }

    public static ThreadFactory getGroupThreadFactory(ThreadGroup group, String threadName, boolean daemon) {
        return new ThreadGroupThreadFactory(group, threadName, daemon);
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool, long timeout, TimeUnit timeUnit) throws InterruptedException {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeout, timeUnit)) {
                pool.shutdownNow();
                pool.awaitTermination(timeout, timeUnit);
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            throw ie;
        }
    }

    public static void cleanThreadLocals2() {
        try {
            Thread thread = Thread.currentThread();
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Object threadLocalTable = threadLocalsField.get(thread);
            Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = threadLocalMapClass.getDeclaredField("table");
            tableField.setAccessible(true);
            Object table = tableField.get(threadLocalTable);
            Field referentField = Reference.class.getDeclaredField("referent");
            referentField.setAccessible(true);
            for (int i = 0; i < Array.getLength(table); ++i) {
                Object entry = Array.get(table, i);
                if (entry == null) continue;
                ThreadLocal threadLocal = (ThreadLocal)referentField.get(entry);
                threadLocal.remove();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            Thread.currentThread().interrupt();
            throw new InterruptedException("interrupted");
        }
    }

    public static ExecutorService newFlexiThreadPool(int corePoolSize, int maximumPoolSize, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newFlexiThreadPool(int maximumPoolSize, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(1, maximumPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    private static class FlexibleThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        protected String name;
        protected boolean daemon;

        public FlexibleThreadFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(this.daemon);
            t.setName(this.name + "-" + this.threadNumber.incrementAndGet());
            return t;
        }
    }

    private static class ThreadGroupThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private boolean daemon;

        ThreadGroupThreadFactory(ThreadGroup group, String threadName, boolean daemon) {
            this.group = group != null ? group : Thread.currentThread().getThreadGroup();
            this.daemon = daemon;
            this.namePrefix = threadName + "-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(this.daemon);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

