/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceObjectType;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.request.GetRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.misc.ItemIdWrapperList;

abstract class GetItemRequestBase<TResponse extends ServiceResponse>
extends GetRequest<Item, TResponse> {
    private ItemIdWrapperList itemIds = new ItemIdWrapperList();

    protected GetItemRequestBase(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getItemIds().iterator(), "ItemIds");
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.itemIds.getCount();
    }

    @Override
    protected ServiceObjectType getServiceObjectType() {
        return ServiceObjectType.Item;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeElementsToXml(writer);
        this.itemIds.writeToXml(writer, XmlNamespace.Messages, "ItemIds");
    }

    @Override
    public String getXmlElementName() {
        return "GetItem";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetItemResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "GetItemResponseMessage";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public ItemIdWrapperList getItemIds() {
        return this.itemIds;
    }
}

