/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.response;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceResult;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;

public final class ServiceResponseCollection<TResponse extends ServiceResponse>
implements Iterable<TResponse> {
    private Vector<TResponse> responses = new Vector();
    private ServiceResult overallResult = ServiceResult.Success;

    public void add(TResponse response) {
        EwsUtilities.ewsAssert(response != null, "EwsResponseList.Add", "response is null");
        if (((ServiceResponse)response).getResult().ordinal() > this.overallResult.ordinal()) {
            this.overallResult = ((ServiceResponse)response).getResult();
        }
        this.responses.add(response);
    }

    public int getCount() {
        return this.responses.size();
    }

    public TResponse getResponseAtIndex(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getCount()) {
            throw new IndexOutOfBoundsException("Index out of Range");
        }
        return (TResponse)((ServiceResponse)this.responses.get(index));
    }

    public ServiceResult getOverallResult() {
        return this.overallResult;
    }

    @Override
    public Iterator<TResponse> iterator() {
        return this.responses.iterator();
    }

    public Enumeration<TResponse> getEnumerator() {
        return this.responses.elements();
    }
}

