/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.folder;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import microsoft.exchange.webservices.data.attribute.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.EffectiveRights;
import microsoft.exchange.webservices.data.core.enumeration.service.SendCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.misc.InvalidOperationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.response.FindItemResponse;
import microsoft.exchange.webservices.data.core.response.ServiceResponseCollection;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.schema.FolderSchema;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.property.complex.ExtendedPropertyCollection;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.FolderPermissionCollection;
import microsoft.exchange.webservices.data.property.complex.ManagedFolderInformation;
import microsoft.exchange.webservices.data.property.definition.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FindItemsResults;
import microsoft.exchange.webservices.data.search.FolderView;
import microsoft.exchange.webservices.data.search.GroupedFindItemsResults;
import microsoft.exchange.webservices.data.search.Grouping;
import microsoft.exchange.webservices.data.search.ItemView;
import microsoft.exchange.webservices.data.search.ViewBase;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ServiceObjectDefinition(xmlElementName="Folder")
public class Folder
extends ServiceObject {
    private static final Log LOG = LogFactory.getLog(Folder.class);
    private static final Map<String, WellKnownFolderName> WELL_KNOWN_FOLDER_MAP = Stream.of(WellKnownFolderName.values()).collect(Collectors.toMap(k -> k.toString().toLowerCase(), Function.identity()));

    public Folder(ExchangeService service) throws Exception {
        super(service);
    }

    public static Folder bind(ExchangeService service, FolderId id, PropertySet propertySet) throws Exception {
        return service.bindToFolder(Folder.class, id, propertySet);
    }

    public static Folder bind(ExchangeService service, FolderId id) throws Exception {
        return Folder.bind(service, id, PropertySet.getFirstClassProperties());
    }

    public static Folder bind(ExchangeService service, WellKnownFolderName name, PropertySet propertySet) throws Exception {
        return Folder.bind(service, new FolderId(name), propertySet);
    }

    public static Folder bind(ExchangeService service, WellKnownFolderName name) throws Exception {
        return Folder.bind(service, new FolderId(name), PropertySet.getFirstClassProperties());
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        try {
            if (this.getPropertyBag().contains(FolderSchema.Permissions)) {
                this.getPermissions().validate();
            }
        }
        catch (ServiceLocalException e) {
            LOG.error((Object)e);
        }
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return FolderSchema.Instance;
    }

    @Override
    public ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    @Override
    public String getChangeXmlElementName() {
        return "FolderChange";
    }

    @Override
    public String getSetFieldXmlElementName() {
        return "SetFolderField";
    }

    @Override
    public String getDeleteFieldXmlElementName() {
        return "DeleteFolderField";
    }

    @Override
    protected void internalLoad(PropertySet propertySet) throws Exception {
        this.throwIfThisIsNew();
        this.getService().loadPropertiesForFolder(this, propertySet);
    }

    @Override
    protected void internalDelete(DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences) throws Exception {
        try {
            this.throwIfThisIsNew();
        }
        catch (InvalidOperationException e) {
            LOG.error((Object)e);
        }
        this.getService().deleteFolder(this.getId(), deleteMode);
    }

    public void delete(DeleteMode deleteMode) throws Exception {
        this.internalDelete(deleteMode, null, null);
    }

    public void empty(DeleteMode deletemode, boolean deleteSubFolders) throws Exception {
        this.throwIfThisIsNew();
        this.getService().emptyFolder(this.getId(), deletemode, deleteSubFolders);
    }

    public void save(FolderId parentFolderId) throws Exception {
        this.throwIfThisIsNotNew();
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        if (this.isDirty()) {
            this.getService().createFolder(this, parentFolderId);
        }
    }

    public void save(WellKnownFolderName parentFolderName) throws Exception {
        this.save(new FolderId(parentFolderName));
    }

    public void update() throws Exception {
        if (this.isDirty() && this.getPropertyBag().getIsUpdateCallNecessary()) {
            this.getService().updateFolder(this);
        }
    }

    public Folder copy(FolderId destinationFolderId) throws Exception {
        this.throwIfThisIsNew();
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.getService().copyFolder(this.getId(), destinationFolderId);
    }

    public Folder copy(WellKnownFolderName destinationFolderName) throws Exception {
        return this.copy(new FolderId(destinationFolderName));
    }

    public Folder move(FolderId destinationFolderId) throws Exception {
        this.throwIfThisIsNew();
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.getService().moveFolder(this.getId(), destinationFolderId);
    }

    public Folder move(WellKnownFolderName destinationFolderName) throws Exception {
        return this.move(new FolderId(destinationFolderName));
    }

    <TItem extends Item> ServiceResponseCollection<FindItemResponse<TItem>> internalFindItems(String queryString, ViewBase view, Grouping groupBy) throws Exception {
        ArrayList<FolderId> folderIdArry = new ArrayList<FolderId>();
        folderIdArry.add(this.getId());
        this.throwIfThisIsNew();
        return this.getService().findItems(folderIdArry, null, queryString, view, groupBy, ServiceErrorHandling.ThrowOnError);
    }

    <TItem extends Item> ServiceResponseCollection<FindItemResponse<TItem>> internalFindItems(SearchFilter searchFilter, ViewBase view, Grouping groupBy) throws Exception {
        ArrayList<FolderId> folderIdArry = new ArrayList<FolderId>();
        folderIdArry.add(this.getId());
        this.throwIfThisIsNew();
        return this.getService().findItems(folderIdArry, searchFilter, null, view, groupBy, ServiceErrorHandling.ThrowOnError);
    }

    public FindItemsResults<Item> findItems(SearchFilter searchFilter, ItemView view) throws Exception {
        EwsUtilities.validateParamAllowNull(searchFilter, "searchFilter");
        ServiceResponseCollection responses = this.internalFindItems(searchFilter, (ViewBase)view, null);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindItemsResults<Item> findItems(String queryString, ItemView view) throws Exception {
        EwsUtilities.validateParamAllowNull(queryString, "queryString");
        ServiceResponseCollection responses = this.internalFindItems(queryString, (ViewBase)view, null);
        return responses.getResponseAtIndex(0).getResults();
    }

    public FindItemsResults<Item> findItems(ItemView view) throws Exception {
        ServiceResponseCollection responses = this.internalFindItems((SearchFilter)null, (ViewBase)view, null);
        return responses.getResponseAtIndex(0).getResults();
    }

    public GroupedFindItemsResults<Item> findItems(SearchFilter searchFilter, ItemView view, Grouping groupBy) throws Exception {
        EwsUtilities.validateParam(groupBy, "groupBy");
        EwsUtilities.validateParamAllowNull(searchFilter, "searchFilter");
        ServiceResponseCollection responses = this.internalFindItems(searchFilter, (ViewBase)view, groupBy);
        return responses.getResponseAtIndex(0).getGroupedFindResults();
    }

    public GroupedFindItemsResults<Item> findItems(String queryString, ItemView view, Grouping groupBy) throws Exception {
        EwsUtilities.validateParam(groupBy, "groupBy");
        ServiceResponseCollection responses = this.internalFindItems(queryString, (ViewBase)view, groupBy);
        return responses.getResponseAtIndex(0).getGroupedFindResults();
    }

    public FindFoldersResults findFolders(FolderView view) throws Exception {
        this.throwIfThisIsNew();
        return this.getService().findFolders(this.getId(), view);
    }

    public FindFoldersResults findFolders(SearchFilter searchFilter, FolderView view) throws Exception {
        this.throwIfThisIsNew();
        return this.getService().findFolders(this.getId(), searchFilter, view);
    }

    public GroupedFindItemsResults<Item> findItems(ItemView view, Grouping groupBy) throws Exception {
        EwsUtilities.validateParam(groupBy, "groupBy");
        return this.findItems((SearchFilter)null, view, groupBy);
    }

    @Override
    public PropertyDefinition getIdPropertyDefinition() {
        return FolderSchema.Id;
    }

    public void setExtendedProperty(ExtendedPropertyDefinition extendedPropertyDefinition, Object value) throws Exception {
        this.getExtendedProperties().setExtendedProperty(extendedPropertyDefinition, value);
    }

    public boolean removeExtendedProperty(ExtendedPropertyDefinition extendedPropertyDefinition) throws Exception {
        return this.getExtendedProperties().removeExtendedProperty(extendedPropertyDefinition);
    }

    @Override
    protected ExtendedPropertyCollection getExtendedProperties() throws Exception {
        return this.getExtendedPropertiesForService();
    }

    @Override
    public FolderId getId() {
        try {
            return (FolderId)this.getPropertyBag().getObjectFromPropertyDefinition(this.getIdPropertyDefinition());
        }
        catch (ServiceLocalException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public FolderId getParentFolderId() throws ServiceLocalException {
        return (FolderId)this.getPropertyBag().getObjectFromPropertyDefinition(FolderSchema.ParentFolderId);
    }

    public int getChildFolderCount() throws NumberFormatException, ServiceLocalException {
        return Integer.parseInt(this.getPropertyBag().getObjectFromPropertyDefinition(FolderSchema.ChildFolderCount).toString());
    }

    public String getDisplayName() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(FolderSchema.DisplayName);
    }

    public WellKnownFolderName getWellKnownFolderName() throws ServiceLocalException {
        return WELL_KNOWN_FOLDER_MAP.get(this.getPropertyBag().getObjectFromPropertyDefinition(FolderSchema.WellKnownFolderName));
    }

    public void setDisplayName(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(FolderSchema.DisplayName, value);
    }

    public String getFolderClass() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(FolderSchema.FolderClass);
    }

    public void setFolderClass(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(FolderSchema.FolderClass, value);
    }

    public int getTotalCount() throws NumberFormatException, ServiceLocalException {
        return Integer.parseInt(this.getPropertyBag().getObjectFromPropertyDefinition(FolderSchema.TotalCount).toString());
    }

    public ExtendedPropertyCollection getExtendedPropertiesForService() throws ServiceLocalException {
        return (ExtendedPropertyCollection)this.getPropertyBag().getObjectFromPropertyDefinition(ServiceObjectSchema.extendedProperties);
    }

    public ManagedFolderInformation getManagedFolderInformation() throws ServiceLocalException {
        return (ManagedFolderInformation)this.getPropertyBag().getObjectFromPropertyDefinition(FolderSchema.ManagedFolderInformation);
    }

    public EnumSet<EffectiveRights> getEffectiveRights() throws ServiceLocalException {
        return (EnumSet)this.getPropertyBag().getObjectFromPropertyDefinition(FolderSchema.EffectiveRights);
    }

    public FolderPermissionCollection getPermissions() throws ServiceLocalException {
        return (FolderPermissionCollection)this.getPropertyBag().getObjectFromPropertyDefinition(FolderSchema.Permissions);
    }

    public int getUnreadCount() throws NumberFormatException, ServiceLocalException {
        return Integer.parseInt(this.getPropertyBag().getObjectFromPropertyDefinition(FolderSchema.UnreadCount).toString());
    }
}

