/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.item;

import java.io.File;
import java.io.InputStream;
import java.util.Date;
import microsoft.exchange.webservices.data.attribute.Attachable;
import microsoft.exchange.webservices.data.attribute.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.PhysicalAddressIndex;
import microsoft.exchange.webservices.data.core.enumeration.service.ContactSource;
import microsoft.exchange.webservices.data.core.enumeration.service.FileAsMapping;
import microsoft.exchange.webservices.data.core.exception.service.local.PropertyException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.schema.ContactSchema;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.Attachment;
import microsoft.exchange.webservices.data.property.complex.ByteArrayArray;
import microsoft.exchange.webservices.data.property.complex.CompleteName;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.EmailAddressCollection;
import microsoft.exchange.webservices.data.property.complex.EmailAddressDictionary;
import microsoft.exchange.webservices.data.property.complex.FileAttachment;
import microsoft.exchange.webservices.data.property.complex.ImAddressDictionary;
import microsoft.exchange.webservices.data.property.complex.ItemAttachment;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.PhoneNumberDictionary;
import microsoft.exchange.webservices.data.property.complex.PhysicalAddressDictionary;
import microsoft.exchange.webservices.data.property.complex.StringList;

@Attachable
@ServiceObjectDefinition(xmlElementName="Contact", returnedByServer=true)
public class Contact
extends Item {
    private final String ContactPictureName = "ContactPicture.jpg";

    public Contact(ExchangeService service) throws Exception {
        super(service);
    }

    public Contact(ItemAttachment parentAttachment) throws Exception {
        super(parentAttachment);
    }

    public static Contact bind(ExchangeService service, ItemId id, PropertySet propertySet) throws Exception {
        return service.bindToItem(Contact.class, id, propertySet);
    }

    public static Contact bind(ExchangeService service, ItemId id) throws Exception {
        return Contact.bind(service, id, PropertySet.getFirstClassProperties());
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return ContactSchema.Instance;
    }

    @Override
    public ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public void setContactPicture(byte[] content) throws Exception {
        EwsUtilities.validateMethodVersion(this.getService(), ExchangeVersion.Exchange2010, "SetContactPicture");
        this.internalRemoveContactPicture();
        FileAttachment fileAttachment = this.getAttachments().addFileAttachment("ContactPicture.jpg", content);
        fileAttachment.setIsContactPhoto(true);
    }

    public void setContactPicture(InputStream contentStream) throws Exception {
        EwsUtilities.validateMethodVersion(this.getService(), ExchangeVersion.Exchange2010, "SetContactPicture");
        this.internalRemoveContactPicture();
        FileAttachment fileAttachment = this.getAttachments().addFileAttachment("ContactPicture.jpg", contentStream);
        fileAttachment.setIsContactPhoto(true);
    }

    public void setContactPicture(String fileName) throws Exception {
        EwsUtilities.validateMethodVersion(this.getService(), ExchangeVersion.Exchange2010, "SetContactPicture");
        this.internalRemoveContactPicture();
        FileAttachment fileAttachment = this.getAttachments().addFileAttachment(new File(fileName).getName(), fileName);
        fileAttachment.setIsContactPhoto(true);
    }

    public FileAttachment getContactPictureAttachment() throws ServiceLocalException {
        EwsUtilities.validateMethodVersion(this.getService(), ExchangeVersion.Exchange2010, "GetContactPictureAttachment");
        if (!this.getPropertyBag().isPropertyLoaded(ContactSchema.Attachments)) {
            throw new PropertyException("The attachment collection must be loaded.");
        }
        for (Attachment fileAttachment : this.getAttachments()) {
            if (!(fileAttachment instanceof FileAttachment) || !((FileAttachment)fileAttachment).isContactPhoto()) continue;
            return (FileAttachment)fileAttachment;
        }
        return null;
    }

    private void internalRemoveContactPicture() throws Exception {
        for (int index = this.getAttachments().getCount() - 1; index >= 0; --index) {
            FileAttachment fileAttachment = (FileAttachment)this.getAttachments().getPropertyAtIndex(index);
            if (fileAttachment == null || !fileAttachment.isContactPhoto()) continue;
            this.getAttachments().remove(fileAttachment);
        }
    }

    public void removeContactPicture() throws Exception {
        EwsUtilities.validateMethodVersion(this.getService(), ExchangeVersion.Exchange2010, "RemoveContactPicture");
        if (!this.getPropertyBag().isPropertyLoaded(ContactSchema.Attachments)) {
            throw new PropertyException("The attachment collection must be loaded.");
        }
        this.internalRemoveContactPicture();
    }

    @Override
    public void validate() throws ServiceVersionException, Exception {
        super.validate();
        OutParam<Object> outParam = new OutParam<Object>();
        if (this.tryGetProperty(ContactSchema.FileAsMapping, outParam)) {
            Object fileAsMapping = outParam.getParam();
            EwsUtilities.validateEnumVersionValue((FileAsMapping)((Object)fileAsMapping), this.getService().getRequestedServerVersion());
        }
    }

    public String getFileAs() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.FileAs);
    }

    public void setFileAs(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.FileAs, value);
    }

    public FileAsMapping getFileAsMapping() throws ServiceLocalException {
        return (FileAsMapping)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.FileAsMapping));
    }

    public void setFileAs(FileAsMapping value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.FileAsMapping, (Object)value);
    }

    public String getDisplayName() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.DisplayName);
    }

    public void setDisplayName(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.DisplayName, value);
    }

    public String getGivenName() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.GivenName);
    }

    public void setGivenName(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.GivenName, value);
    }

    public String getInitials() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Initials);
    }

    public void setInitials(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.Initials, value);
    }

    public String getMiddleName() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.MiddleName);
    }

    public void setMiddleName(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.MiddleName, value);
    }

    public String getNickName() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.NickName);
    }

    public void setNickName(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.NickName, value);
    }

    public CompleteName getCompleteName() throws ServiceLocalException {
        return (CompleteName)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.CompleteName);
    }

    public String getCompanyName() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.CompanyName);
    }

    public void setCompanyName(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.CompanyName, value);
    }

    public EmailAddressDictionary getEmailAddresses() throws ServiceLocalException {
        return (EmailAddressDictionary)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.EmailAddresses);
    }

    public PhysicalAddressDictionary getPhysicalAddresses() throws ServiceLocalException {
        return (PhysicalAddressDictionary)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.PhysicalAddresses);
    }

    public PhoneNumberDictionary getPhoneNumbers() throws ServiceLocalException {
        return (PhoneNumberDictionary)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.PhoneNumbers);
    }

    public String getAssistantName() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.AssistantName);
    }

    public void setAssistantName(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.AssistantName, value);
    }

    public Date getBirthday() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Birthday);
    }

    public void setBirthday(Date value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.Birthday, value);
    }

    public String getBusinessHomePage() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.BusinessHomePage);
    }

    public void setBusinessHomePage(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.BusinessHomePage, value);
    }

    public StringList getChildren() throws ServiceLocalException {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Children);
    }

    public void setChildren(StringList value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.Children, value);
    }

    public StringList getCompanies() throws ServiceLocalException {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Companies);
    }

    public void setCompanies(StringList value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.Companies, value);
    }

    public ContactSource getContactSource() throws ServiceLocalException {
        return (ContactSource)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.ContactSource));
    }

    public String getDepartment() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Department);
    }

    public void setDepartment(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.Department, value);
    }

    public String getGeneration() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Generation);
    }

    public void setGeneration(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.Generation, value);
    }

    public ImAddressDictionary getImAddresses() throws ServiceLocalException {
        return (ImAddressDictionary)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.ImAddresses);
    }

    public String getJobTitle() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.JobTitle);
    }

    public void setJobTitle(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.JobTitle, value);
    }

    public String getManager() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Manager);
    }

    public void setManager(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.Manager, value);
    }

    public String getMileage() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Mileage);
    }

    public void setMileage(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.Mileage, value);
    }

    public String getOfficeLocation() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.OfficeLocation);
    }

    public void setOfficeLocation(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.OfficeLocation, value);
    }

    public PhysicalAddressIndex getPostalAddressIndex() throws ServiceLocalException {
        return (PhysicalAddressIndex)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.PostalAddressIndex));
    }

    public void setPostalAddressIndex(PhysicalAddressIndex value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.PostalAddressIndex, (Object)value);
    }

    public String getProfession() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Profession);
    }

    public void setProfession(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.Profession, value);
    }

    public String getSpouseName() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.SpouseName);
    }

    public void setSpouseName(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.SpouseName, value);
    }

    public String getSurname() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Surname);
    }

    public void setSurname(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.Surname, value);
    }

    public Date getWeddingAnniversary() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.WeddingAnniversary);
    }

    public void setWeddingAnniversary(Date value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ContactSchema.WeddingAnniversary, value);
    }

    public Boolean getHasPicture() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.HasPicture);
    }

    public String getPhoneticFullName() throws Exception {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.PhoneticFullName);
    }

    public String getPhoneticFirstName() throws Exception {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.PhoneticFirstName);
    }

    public String getPhoneticLastName() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.PhoneticLastName);
    }

    public String getAlias() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Alias);
    }

    public String getNotes() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Notes);
    }

    public byte[] getDirectoryPhoto() throws ServiceLocalException {
        return (byte[])this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.Photo);
    }

    public byte[][] getUserSMIMECertificate() throws ServiceLocalException {
        ByteArrayArray array = (ByteArrayArray)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.UserSMIMECertificate);
        return array.getContent();
    }

    public byte[][] getMSExchangeCertificate() throws ServiceLocalException {
        ByteArrayArray array = (ByteArrayArray)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.MSExchangeCertificate);
        return array.getContent();
    }

    public String getDirectoryId() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.DirectoryId);
    }

    public EmailAddress getManagerMailbox() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.ManagerMailbox);
    }

    public EmailAddressCollection getDirectReports() throws ServiceLocalException {
        return (EmailAddressCollection)this.getPropertyBag().getObjectFromPropertyDefinition(ContactSchema.DirectReports);
    }
}

