/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import org.apache.commons.codec.binary.Base64;

public final class MimeContent
extends ComplexProperty {
    private String characterSet;
    private byte[] content;

    public MimeContent() {
    }

    public MimeContent(String characterSet, byte[] content) {
        this();
        this.characterSet = characterSet;
        this.content = content;
    }

    @Override
    public void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.characterSet = reader.readAttributeValue(String.class, "CharacterSet");
    }

    @Override
    public void readTextValueFromXml(EwsServiceXmlReader reader) throws XMLStreamException, ServiceXmlDeserializationException {
        this.content = Base64.decodeBase64((String)reader.readValue());
    }

    @Override
    public void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("CharacterSet", this.characterSet);
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException {
        if (this.content != null && this.content.length > 0) {
            writer.writeBase64ElementValue(this.content);
        }
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.canSetFieldValue(this.characterSet, characterSet);
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.canSetFieldValue(this.content, content);
    }

    public String toString() {
        if (this.getContent() == null) {
            return "";
        }
        try {
            String charSet = this.getCharacterSet() == null || this.getCharacterSet().isEmpty() ? "UTF-8" : this.getCharacterSet();
            return new String(this.getContent(), charSet);
        }
        catch (Exception e) {
            return Base64.encodeBase64String((byte[])this.getContent());
        }
    }
}

