/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover.exception.error;

import microsoft.exchange.webservices.data.autodiscover.enumeration.AutodiscoverErrorCode;
import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;

public final class DomainSettingError {
    private AutodiscoverErrorCode errorCode;
    private String errorMessage;
    private String settingName;

    public void loadFromXml(EwsXmlReader reader) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("ErrorCode")) {
                this.errorCode = reader.readElementValue(AutodiscoverErrorCode.class);
                continue;
            }
            if (reader.getLocalName().equals("ErrorMessage")) {
                this.errorMessage = reader.readElementValue();
                continue;
            }
            if (!reader.getLocalName().equals("SettingName")) continue;
            this.settingName = reader.readElementValue();
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, "DomainSettingError"));
    }

    public AutodiscoverErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSettingName() {
        return this.settingName;
    }
}

