/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core;

import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import microsoft.exchange.webservices.data.core.EwsX509TrustManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContexts;

public class EwsSSLProtocolSocketFactory
extends SSLConnectionSocketFactory {
    private static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = new DefaultHostnameVerifier();
    private final SSLContext sslcontext;

    public EwsSSLProtocolSocketFactory(SSLContext context, HostnameVerifier hostnameVerifier) {
        super(context, hostnameVerifier);
        this.sslcontext = context;
    }

    public static EwsSSLProtocolSocketFactory build(TrustManager trustManager) throws GeneralSecurityException {
        return EwsSSLProtocolSocketFactory.build(trustManager, DEFAULT_HOSTNAME_VERIFIER);
    }

    public static EwsSSLProtocolSocketFactory build(TrustManager trustManager, HostnameVerifier hostnameVerifier) throws GeneralSecurityException {
        SSLContext sslContext = EwsSSLProtocolSocketFactory.createSslContext(trustManager);
        return new EwsSSLProtocolSocketFactory(sslContext, hostnameVerifier);
    }

    public static SSLContext createSslContext(TrustManager trustManager) throws GeneralSecurityException {
        EwsX509TrustManager x509TrustManager = new EwsX509TrustManager(null, trustManager);
        SSLContext sslContext = SSLContexts.createDefault();
        sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
        return sslContext;
    }

    public SSLContext getContext() {
        return this.sslcontext;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(EwsSSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return EwsSSLProtocolSocketFactory.class.hashCode();
    }
}

