/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.DeleteAttachmentResponse;
import microsoft.exchange.webservices.data.property.complex.Attachment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DeleteAttachmentRequest
extends MultiResponseServiceRequest<DeleteAttachmentResponse> {
    private static final Log LOG = LogFactory.getLog(DeleteAttachmentRequest.class);
    private List<Attachment> attachments = new ArrayList<Attachment>();

    public DeleteAttachmentRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() {
        try {
            super.validate();
            EwsUtilities.validateParamCollection(this.getAttachments().iterator(), "Attachments");
            for (int i = 0; i < this.attachments.size(); ++i) {
                EwsUtilities.validateParam(this.attachments.get(i).getId(), String.format("Attachment[%d].Id ", i));
            }
        }
        catch (ServiceLocalException e) {
            LOG.error((Object)e);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    @Override
    protected DeleteAttachmentResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new DeleteAttachmentResponse(this.attachments.get(responseIndex));
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.attachments.size();
    }

    @Override
    public String getXmlElementName() {
        return "DeleteAttachment";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "DeleteAttachmentResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "DeleteAttachmentResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, "AttachmentIds");
        for (Attachment attachment : this.attachments) {
            writer.writeStartElement(XmlNamespace.Types, "AttachmentId");
            writer.writeAttributeValue("Id", attachment.getId());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }
}

