/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.item;

import java.util.Arrays;
import java.util.Date;
import microsoft.exchange.webservices.data.attribute.Attachable;
import microsoft.exchange.webservices.data.attribute.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.service.ResponseMessageType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.response.PostReply;
import microsoft.exchange.webservices.data.core.service.response.ResponseMessage;
import microsoft.exchange.webservices.data.core.service.schema.EmailMessageSchema;
import microsoft.exchange.webservices.data.core.service.schema.PostItemSchema;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.ItemAttachment;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.MessageBody;

@Attachable
@ServiceObjectDefinition(xmlElementName="PostItem")
public final class PostItem
extends Item {
    public PostItem(ExchangeService service) throws Exception {
        super(service);
    }

    public PostItem(ItemAttachment parentAttachment) throws Exception {
        super(parentAttachment);
    }

    public static PostItem bind(ExchangeService service, ItemId id, PropertySet propertySet) throws Exception {
        return service.bindToItem(PostItem.class, id, propertySet);
    }

    public static PostItem bind(ExchangeService service, ItemId id) throws Exception {
        return PostItem.bind(service, id, PropertySet.getFirstClassProperties());
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return PostItemSchema.Instance;
    }

    @Override
    public ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public PostReply createPostReply() throws Exception {
        this.throwIfThisIsNew();
        return new PostReply(this);
    }

    public void postReply(MessageBody bodyPrefix) throws Exception {
        PostReply postReply = this.createPostReply();
        postReply.setBodyPrefix(bodyPrefix);
        postReply.save();
    }

    public ResponseMessage createReply(boolean replyAll) throws Exception {
        this.throwIfThisIsNew();
        return new ResponseMessage(this, replyAll ? ResponseMessageType.ReplyAll : ResponseMessageType.Reply);
    }

    public void reply(MessageBody bodyPrefix, boolean replyAll) throws Exception {
        ResponseMessage responseMessage = this.createReply(replyAll);
        responseMessage.setBodyPrefix(bodyPrefix);
        responseMessage.sendAndSaveCopy();
    }

    public ResponseMessage createForward() throws Exception {
        this.throwIfThisIsNew();
        return new ResponseMessage(this, ResponseMessageType.Forward);
    }

    public void forward(MessageBody bodyPrefix, EmailAddress ... toRecipients) throws Exception {
        this.forward(bodyPrefix, Arrays.asList(toRecipients));
    }

    public void forward(MessageBody bodyPrefix, Iterable<EmailAddress> toRecipients) throws Exception {
        ResponseMessage responseMessage = this.createForward();
        responseMessage.setBodyPrefix(bodyPrefix);
        responseMessage.getToRecipients().addEmailRange(toRecipients.iterator());
        responseMessage.sendAndSaveCopy();
    }

    public byte[] getConversationIndex() throws ServiceLocalException {
        return (byte[])this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ConversationIndex);
    }

    public String getConversationTopic() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ConversationTopic);
    }

    public EmailAddress getFrom() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.From);
    }

    public void setFrom(EmailAddress value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.From, value);
    }

    public String getInternetMessageId() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.InternetMessageId);
    }

    public Boolean getIsRead() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.IsRead);
    }

    public void setIsRead(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsRead, value);
    }

    public Date getPostedTime() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(PostItemSchema.PostedTime);
    }

    public String getReferences() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.References);
    }

    public void setIsRead(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.References, value);
    }

    public EmailAddress getSender() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.Sender);
    }

    public void setSender(EmailAddress value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.Sender, value);
    }
}

