/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.messaging;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.service.PhoneCallState;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ConnectionFailureCause;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.messaging.PhoneCallId;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;

public final class PhoneCall
extends ComplexProperty {
    private static final String SuccessfullResponseText = "OK";
    private static final int SuccessfullResponseCode = 200;
    private ExchangeService service;
    private PhoneCallState state;
    private ConnectionFailureCause connectionFailureCause;
    private String sipResponseText;
    private int sipResponseCode;
    private PhoneCallId id;

    public PhoneCall(ExchangeService service) {
        EwsUtilities.ewsAssert(service != null, "PhoneCall.ctor", "service is null");
        this.service = service;
        this.state = PhoneCallState.Connecting;
        this.connectionFailureCause = ConnectionFailureCause.None;
        this.sipResponseText = SuccessfullResponseText;
        this.sipResponseCode = 200;
    }

    protected PhoneCall(ExchangeService service, PhoneCallId id) {
        this(service);
        this.id = id;
    }

    public void refresh() throws Exception {
        PhoneCall phoneCall = this.service.getUnifiedMessaging().getPhoneCallInformation(this.id);
        this.state = phoneCall.getState();
        this.connectionFailureCause = phoneCall.getConnectionFailureCause();
        this.sipResponseText = phoneCall.getSipResponseText();
        this.sipResponseCode = phoneCall.getSipResponseCode();
    }

    public void disconnect() throws Exception {
        if (this.state == PhoneCallState.Disconnected) {
            throw new ServiceLocalException("The phone call has already been disconnected.");
        }
        this.service.getUnifiedMessaging().disconnectPhoneCall(this.id);
        this.state = PhoneCallState.Disconnected;
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("PhoneCallState")) {
            this.state = reader.readElementValue(PhoneCallState.class);
            return true;
        }
        if (reader.getLocalName().equals("ConnectionFailureCause")) {
            this.connectionFailureCause = reader.readElementValue(ConnectionFailureCause.class);
            return true;
        }
        if (reader.getLocalName().equals("SIPResponseText")) {
            this.sipResponseText = reader.readElementValue();
            return true;
        }
        if (reader.getLocalName().equals("SIPResponseCode")) {
            this.sipResponseCode = reader.readElementValue(Integer.class);
            return true;
        }
        return false;
    }

    public PhoneCallState getState() {
        return this.state;
    }

    public String getSipResponseText() {
        return this.sipResponseText;
    }

    public int getSipResponseCode() {
        return this.sipResponseCode;
    }

    public ConnectionFailureCause getConnectionFailureCause() {
        return this.connectionFailureCause;
    }
}

