/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.Iterator;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.property.complex.ComplexPropertyCollection;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;

public final class EmailAddressCollection
extends ComplexPropertyCollection<EmailAddress> {
    private String collectionItemXmlElementName;

    public EmailAddressCollection() {
        this("Mailbox");
    }

    protected EmailAddressCollection(String collectionItemXmlElementName) {
        this.collectionItemXmlElementName = collectionItemXmlElementName;
    }

    public void add(EmailAddress emailAddress) {
        this.internalAdd(emailAddress);
    }

    public void addEmailRange(Iterator<EmailAddress> emailAddresses) {
        if (null != emailAddresses) {
            while (emailAddresses.hasNext()) {
                this.add(emailAddresses.next());
            }
        }
    }

    public EmailAddress add(String smtpAddress) {
        EmailAddress emailAddress = new EmailAddress(smtpAddress);
        this.add(emailAddress);
        return emailAddress;
    }

    public void addSmtpAddressRange(Iterator<String> smtpAddresses) {
        if (null != smtpAddresses) {
            while (smtpAddresses.hasNext()) {
                this.add(smtpAddresses.next());
            }
        }
    }

    public EmailAddress add(String name, String smtpAddress) {
        EmailAddress emailAddress = new EmailAddress(name, smtpAddress);
        this.add(emailAddress);
        return emailAddress;
    }

    public void clear() {
        this.internalClear();
    }

    public void removeAt(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new IllegalArgumentException(String.format("index %d is out of range [0..%d[.", index, this.getCount()));
        }
        this.internalRemoveAt(index);
    }

    public boolean remove(EmailAddress emailAddress) throws Exception {
        EwsUtilities.validateParam(emailAddress, "emailAddress");
        return this.internalRemove(emailAddress);
    }

    @Override
    protected EmailAddress createComplexProperty(String xmlElementName) {
        if (xmlElementName.equals(this.collectionItemXmlElementName)) {
            return new EmailAddress();
        }
        return null;
    }

    @Override
    protected String getCollectionItemXmlElementName(EmailAddress complexProperty) {
        return this.collectionItemXmlElementName;
    }

    @Override
    public boolean shouldWriteToXml() {
        return true;
    }
}

