/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.property.complex.Attachment;
import org.apache.commons.io.IOUtils;

public final class FileAttachment
extends Attachment {
    private String fileName;
    private InputStream contentStream;
    private byte[] content;
    private OutputStream loadToStream;
    private boolean isContactPhoto;

    protected FileAttachment(Item owner) {
        super(owner);
    }

    @Override
    public String getXmlElementName() {
        return "FileAttachment";
    }

    @Override
    protected void validate(int attachmentIndex) throws ServiceValidationException {
        if ((this.fileName == null || this.fileName.isEmpty()) && this.content == null && this.contentStream == null) {
            throw new ServiceValidationException(String.format("The content of the file attachment at index %d must be set.", attachmentIndex));
        }
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        boolean result = super.tryReadElementFromXml(reader);
        if (!result) {
            if (reader.getLocalName().equals("IsContactPhoto")) {
                this.isContactPhoto = reader.readElementValue(Boolean.class);
            } else if (reader.getLocalName().equals("Content")) {
                if (this.loadToStream != null) {
                    reader.readBase64ElementValue(this.loadToStream);
                } else if (reader.getService().getFileAttachmentContentHandler() != null) {
                    OutputStream outputStream = reader.getService().getFileAttachmentContentHandler().getOutputStream(this.getId());
                    if (outputStream != null) {
                        reader.readBase64ElementValue(outputStream);
                    } else {
                        this.content = reader.readBase64ElementValue();
                    }
                } else {
                    this.content = reader.readBase64ElementValue();
                }
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean tryReadElementFromXmlToPatch(EwsServiceXmlReader reader) throws Exception {
        return super.tryReadElementFromXml(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeElementsToXml(writer);
        if (writer.getService().getRequestedServerVersion().ordinal() > ExchangeVersion.Exchange2007_SP1.ordinal()) {
            writer.writeElementValue(XmlNamespace.Types, "IsContactPhoto", this.isContactPhoto);
        }
        writer.writeStartElement(XmlNamespace.Types, "Content");
        if (this.fileName != null && !this.fileName.isEmpty()) {
            File fileStream = new File(this.fileName);
            try (FileInputStream fis = null;){
                fis = new FileInputStream(fileStream);
                writer.writeBase64ElementValue(fis);
            }
        } else if (this.contentStream != null) {
            writer.writeBase64ElementValue(this.contentStream);
        } else if (this.content != null) {
            writer.writeBase64ElementValue(this.content);
        } else {
            EwsUtilities.ewsAssert(false, "FileAttachment.WriteElementsToXml", "The attachment's content is not set.");
        }
        writer.writeEndElement();
    }

    public void load(OutputStream stream) throws Exception {
        this.loadToStream = stream;
        try {
            this.load();
        }
        finally {
            this.loadToStream = null;
        }
    }

    public void load(String fileName) throws Exception {
        File fileStream = new File(fileName);
        try {
            this.loadToStream = new FileOutputStream(fileStream);
            this.load();
            this.loadToStream.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.loadToStream);
            this.loadToStream = null;
        }
        this.fileName = fileName;
        this.content = null;
        this.contentStream = null;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected void setFileName(String fileName) {
        this.throwIfThisIsNotNew();
        this.fileName = fileName;
        this.content = null;
        this.contentStream = null;
    }

    protected InputStream getContentStream() {
        return this.contentStream;
    }

    protected void setContentStream(InputStream contentStream) {
        this.throwIfThisIsNotNew();
        this.contentStream = contentStream;
        this.content = null;
        this.fileName = null;
    }

    public byte[] getContent() {
        return this.content;
    }

    protected void setContent(byte[] content) {
        this.throwIfThisIsNotNew();
        this.content = content;
        this.fileName = null;
        this.contentStream = null;
    }

    public boolean isContactPhoto() throws ServiceVersionException {
        EwsUtilities.validatePropertyVersion(this.getOwner().getService(), ExchangeVersion.Exchange2010, "IsContactPhoto");
        return this.isContactPhoto;
    }

    public void setIsContactPhoto(boolean isContactPhoto) throws ServiceVersionException {
        EwsUtilities.validatePropertyVersion(this.getOwner().getService(), ExchangeVersion.Exchange2010, "IsContactPhoto");
        this.throwIfThisIsNotNew();
        this.isContactPhoto = isContactPhoto;
    }
}

