/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.property.BodyType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MessageBody
extends ComplexProperty {
    private static final Log log = LogFactory.getLog(MessageBody.class);
    private BodyType bodyType;
    private String text;

    public MessageBody() {
    }

    public MessageBody(BodyType bodyType, String text) {
        this();
        this.bodyType = bodyType;
        this.text = text;
    }

    public MessageBody(String text) {
        this(BodyType.HTML, text);
    }

    public static MessageBody getMessageBodyFromText(String textBody) {
        return new MessageBody(BodyType.HTML, textBody);
    }

    public static String getStringFromMessageBody(MessageBody messageBody) throws Exception {
        EwsUtilities.validateParam(messageBody, "messageBody");
        return messageBody.text;
    }

    @Override
    public void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.bodyType = reader.readAttributeValue(BodyType.class, "BodyType");
    }

    @Override
    public void readTextValueFromXml(EwsServiceXmlReader reader) throws XMLStreamException, ServiceXmlDeserializationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading text value from XML. BodyType = " + (Object)((Object)this.getBodyType()) + ", keepWhiteSpace = " + (this.getBodyType() == BodyType.Text ? "true." : "false.")));
        }
        this.text = reader.readValue(this.getBodyType() == BodyType.Text);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Text value read:\n---\n" + this.text + "\n---"));
        }
    }

    @Override
    public void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("BodyType", (Object)this.getBodyType());
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        if (null != this.text && !this.text.isEmpty()) {
            writer.writeValue(this.getText(), "Body");
        }
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(BodyType bodyType) {
        if (this.canSetFieldValue(this.bodyType, bodyType)) {
            this.bodyType = bodyType;
            this.changed();
        }
    }

    private String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.canSetFieldValue(this.text, text)) {
            this.text = text;
            this.changed();
        }
    }

    public String toString() {
        return this.text == null ? "" : this.text;
    }
}

