/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.property.PhoneNumberKey;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.DictionaryProperty;
import microsoft.exchange.webservices.data.property.complex.PhoneNumberEntry;

@EditorBrowsable(state=EditorBrowsableState.Never)
public final class PhoneNumberDictionary
extends DictionaryProperty<PhoneNumberKey, PhoneNumberEntry> {
    @Override
    protected String getFieldURI() {
        return "contacts:PhoneNumber";
    }

    @Override
    protected PhoneNumberEntry createEntryInstance() {
        return new PhoneNumberEntry();
    }

    public String getPhoneNumber(PhoneNumberKey key) {
        PhoneNumberEntry phoneNumberEntry = (PhoneNumberEntry)this.getEntries().get((Object)key);
        if (phoneNumberEntry == null) {
            return null;
        }
        return phoneNumberEntry.getPhoneNumber();
    }

    public void setPhoneNumber(PhoneNumberKey key, String value) {
        if (value == null) {
            this.internalRemove(key);
        } else if (this.getEntries().containsKey((Object)key)) {
            PhoneNumberEntry entry = (PhoneNumberEntry)this.getEntries().get((Object)key);
            entry.setPhoneNumber(value);
            this.complexPropertyChanged(entry);
            this.changed();
        } else {
            PhoneNumberEntry entry = new PhoneNumberEntry(key, value);
            this.internalAdd(entry);
        }
    }

    public boolean tryGetValue(PhoneNumberKey key, OutParam<String> outparam) {
        String phoneNumber = this.getPhoneNumber(key);
        if (phoneNumber == null) {
            return false;
        }
        outparam.setParam((Object)phoneNumber);
        return true;
    }
}

