/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.ISymAuth;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.NoConfigException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.Token;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.HttpClientBuilderHelper;

public final class SymBotAuth
extends APIClient
implements ISymAuth {
    private final Logger logger = LoggerFactory.getLogger(SymBotAuth.class);
    private String sessionToken;
    private String kmToken;
    private SymConfig config;
    private Client sessionAuthClient;
    private Client kmAuthClient;
    private long lastAuthTime = 0L;
    private int authRetries = 0;

    public SymBotAuth(SymConfig config) {
        this.config = config;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBotBuilder(config);
        Client client = clientBuilder.build();
        if (StringUtils.isEmpty((CharSequence)config.getProxyURL()) && StringUtils.isEmpty((CharSequence)config.getPodProxyURL())) {
            this.sessionAuthClient = client;
        } else {
            String proxyURL = !StringUtils.isEmpty((CharSequence)config.getPodProxyURL()) ? config.getPodProxyURL() : config.getProxyURL();
            String proxyUser = !StringUtils.isEmpty((CharSequence)config.getPodProxyUsername()) ? config.getPodProxyUsername() : config.getProxyUsername();
            String proxyPass = !StringUtils.isEmpty((CharSequence)config.getPodProxyPassword()) ? config.getPodProxyPassword() : config.getProxyPassword();
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.property("jersey.config.client.proxy.uri", (Object)proxyURL);
            if (!StringUtils.isEmpty((CharSequence)proxyUser) && !StringUtils.isEmpty((CharSequence)proxyPass)) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)proxyUser);
                clientConfig.property("jersey.config.client.proxy.password", (Object)proxyPass);
            }
            this.sessionAuthClient = clientBuilder.withConfig((Configuration)clientConfig).build();
        }
        if (StringUtils.isEmpty((CharSequence)config.getKeyManagerProxyURL())) {
            this.kmAuthClient = client;
        } else {
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.property("jersey.config.client.proxy.uri", (Object)config.getKeyManagerProxyURL());
            if (config.getKeyManagerProxyUsername() != null && config.getKeyManagerProxyPassword() != null) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)config.getKeyManagerProxyUsername());
                clientConfig.property("jersey.config.client.proxy.password", (Object)config.getKeyManagerProxyPassword());
            }
            this.kmAuthClient = clientBuilder.withConfig((Configuration)clientConfig).build();
        }
    }

    public SymBotAuth(SymConfig inputConfig, ClientConfig sessionAuthClientConfig, ClientConfig kmAuthClientConfig) {
        this.logger.info("SymBotAuth with ClientConfig variables");
        this.config = inputConfig;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBotBuilder(this.config);
        this.sessionAuthClient = sessionAuthClientConfig != null ? clientBuilder.withConfig((Configuration)sessionAuthClientConfig).build() : clientBuilder.build();
        this.kmAuthClient = kmAuthClientConfig != null ? clientBuilder.withConfig((Configuration)kmAuthClientConfig).build() : clientBuilder.build();
    }

    @Override
    public void authenticate() {
        if (this.lastAuthTime == 0L | System.currentTimeMillis() - this.lastAuthTime > 3000L) {
            this.sessionAuthenticate();
            this.kmAuthenticate();
            this.lastAuthTime = System.currentTimeMillis();
        } else {
            try {
                this.logger.info("Re-authenticated too fast. Wait 30 seconds to try again.");
                TimeUnit.SECONDS.sleep(30L);
                this.authenticate();
            }
            catch (InterruptedException e) {
                this.logger.error("Error with authentication", (Throwable)e);
            }
        }
    }

    @Override
    public void sessionAuthenticate() {
        if (this.config != null) {
            this.logger.info("Session auth");
            Response response = this.sessionAuthClient.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/sessionauth/v1/authenticate").request(new String[]{"application/json"}).post(null);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, null);
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error, retry authentication in 30 seconds", (Throwable)e);
                }
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException e) {
                    this.logger.error("Error with session authentication", (Throwable)e);
                }
                if (this.authRetries++ > 5) {
                    this.logger.error("Max retries reached. Giving up on auth.");
                    return;
                }
                this.sessionAuthenticate();
            } else {
                Token sessionTokenResponseContent = (Token)response.readEntity(Token.class);
                this.sessionToken = sessionTokenResponseContent.getToken();
            }
        } else {
            throw new NoConfigException("Must provide a SymConfig object to authenticate");
        }
    }

    @Override
    public void kmAuthenticate() {
        this.logger.info("KM auth");
        if (this.config != null) {
            Response response = this.kmAuthClient.target("https://" + this.config.getKeyAuthHost() + ":" + this.config.getKeyAuthPort()).path("/keyauth/v1/authenticate").request(new String[]{"application/json"}).post(null);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, null);
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error, retry authentication in 30 seconds", (Throwable)e);
                }
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException e) {
                    this.logger.error("Error with authentication", (Throwable)e);
                }
                if (this.authRetries++ > 5) {
                    this.logger.error("Max retries reached. Giving up on auth.");
                    return;
                }
                this.kmAuthenticate();
            } else {
                Token kmTokenResponseContent = (Token)response.readEntity(Token.class);
                this.kmToken = kmTokenResponseContent.getToken();
            }
        } else {
            throw new NoConfigException("Must provide a SymConfig object to authenticate");
        }
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void setSessionToken(String sessionTokenInput) {
        this.sessionToken = sessionTokenInput;
    }

    @Override
    public String getKmToken() {
        return this.kmToken;
    }

    @Override
    public void setKmToken(String kmTokenInput) {
        this.kmToken = kmTokenInput;
    }

    @Override
    public void logout() {
        this.logger.info("Logging out");
        Response response = this.sessionAuthClient.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/sessionauth/v1/logout").request(new String[]{"application/json"}).header("sessionToken", (Object)this.getSessionToken()).post(null);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error, retry logout in 30 seconds", (Throwable)e);
            }
        }
    }
}

