/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.AuthEndpointConstants;
import authentication.ISymAuth;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.Token;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.HttpClientBuilderHelper;
import utils.JwtHelper;

public class SymBotRSAAuth
extends APIClient
implements ISymAuth {
    private final Logger logger = LoggerFactory.getLogger(SymBotRSAAuth.class);
    private String sessionToken;
    private String kmToken;
    private SymConfig config;
    private Client sessionAuthClient;
    private Client kmAuthClient;
    private String jwt;
    private long lastAuthTime = 0L;
    private int authRetries = 0;

    public SymBotRSAAuth(SymConfig config) {
        this.config = config;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config);
        Client client = clientBuilder.build();
        if (StringUtils.isEmpty((CharSequence)config.getProxyURL()) && StringUtils.isEmpty((CharSequence)config.getPodProxyURL())) {
            this.sessionAuthClient = client;
        } else {
            String proxyURL = !StringUtils.isEmpty((CharSequence)config.getPodProxyURL()) ? config.getPodProxyURL() : config.getProxyURL();
            String proxyUser = !StringUtils.isEmpty((CharSequence)config.getPodProxyUsername()) ? config.getPodProxyUsername() : config.getProxyUsername();
            String proxyPass = !StringUtils.isEmpty((CharSequence)config.getPodProxyPassword()) ? config.getPodProxyPassword() : config.getProxyPassword();
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            clientConfig.property("jersey.config.client.proxy.uri", (Object)proxyURL);
            if (!StringUtils.isEmpty((CharSequence)proxyUser) && !StringUtils.isEmpty((CharSequence)proxyPass)) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)proxyUser);
                clientConfig.property("jersey.config.client.proxy.password", (Object)proxyPass);
            }
            this.sessionAuthClient = clientBuilder.withConfig((Configuration)clientConfig).build();
        }
        if (StringUtils.isEmpty((CharSequence)config.getKeyManagerProxyURL())) {
            this.kmAuthClient = client;
        } else {
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            clientConfig.property("jersey.config.client.proxy.uri", (Object)config.getKeyManagerProxyURL());
            if (config.getKeyManagerProxyUsername() != null && config.getKeyManagerProxyUsername() != null) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)config.getKeyManagerProxyUsername());
                clientConfig.property("jersey.config.client.proxy.password", (Object)config.getKeyManagerProxyPassword());
            }
            this.kmAuthClient = clientBuilder.withConfig((Configuration)clientConfig).build();
        }
    }

    public SymBotRSAAuth(SymConfig config, ClientConfig sessionAuthClientConfig, ClientConfig kmAuthClientConfig) {
        this.logger.info("SymOBOAuth with ClientConfig variables");
        this.config = config;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config);
        this.sessionAuthClient = sessionAuthClientConfig != null ? clientBuilder.withConfig((Configuration)sessionAuthClientConfig).build() : clientBuilder.build();
        this.kmAuthClient = kmAuthClientConfig != null ? clientBuilder.withConfig((Configuration)kmAuthClientConfig).build() : clientBuilder.build();
    }

    @Override
    public void authenticate() {
        PrivateKey privateKey = null;
        try {
            privateKey = JwtHelper.parseRSAPrivateKey(new File(this.config.getBotPrivateKeyPath() + this.config.getBotPrivateKeyName()));
        }
        catch (IOException | GeneralSecurityException e) {
            this.logger.error("Error trying to parse RSA private key", (Throwable)e);
        }
        if (this.lastAuthTime == 0L | System.currentTimeMillis() - this.lastAuthTime > 3000L) {
            this.logger.info("Last auth time was {}", (Object)this.lastAuthTime);
            this.logger.info("Now is {}", (Object)System.currentTimeMillis());
            this.jwt = JwtHelper.createSignedJwt(this.config.getBotUsername(), AuthEndpointConstants.JWT_EXPIRY_MS, privateKey);
            this.sessionAuthenticate();
            this.kmAuthenticate();
            this.lastAuthTime = System.currentTimeMillis();
        } else {
            try {
                this.logger.info("Re-authenticated too fast. Wait 30 seconds to try again.");
                TimeUnit.SECONDS.sleep(30L);
                this.authenticate();
            }
            catch (InterruptedException e) {
                this.logger.error("Error with authentication", (Throwable)e);
            }
        }
    }

    @Override
    public void sessionAuthenticate() {
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("token", this.jwt);
        Response response = this.sessionAuthClient.target("https://" + this.config.getPodHost() + ":" + this.config.getPodPort()).path("/login/pubkey/authenticate").request(new String[]{"application/json"}).post(Entity.entity(token, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error, retry authentication in 30 seconds");
            }
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException e) {
                this.logger.error("Error with authentication", (Throwable)e);
            }
            if (this.authRetries++ > 5) {
                this.logger.error("Max retries reached. Giving up on auth.");
                return;
            }
            this.sessionAuthenticate();
        } else {
            this.sessionToken = ((Token)response.readEntity(Token.class)).getToken();
        }
    }

    @Override
    public void kmAuthenticate() {
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("token", this.jwt);
        Response response = this.kmAuthClient.target("https://" + this.config.getKeyAuthHost() + ":" + this.config.getKeyAuthPort()).path("/relay/pubkey/authenticate").request(new String[]{"application/json"}).post(Entity.entity(token, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error, retry authentication in 30 seconds");
            }
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException e) {
                this.logger.error("Error with authentication", (Throwable)e);
            }
            if (this.authRetries++ > 5) {
                this.logger.error("Max retries reached. Giving up on auth.");
                return;
            }
            this.kmAuthenticate();
        } else {
            this.kmToken = ((Token)response.readEntity(Token.class)).getToken();
        }
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Override
    public String getKmToken() {
        return this.kmToken;
    }

    @Override
    public void setKmToken(String kmToken) {
        this.kmToken = kmToken;
    }

    @Override
    public void logout() {
        this.logger.info("Logging out");
        Client client = ClientBuilder.newClient();
        Response response = client.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/sessionauth/v1/logout").request(new String[]{"application/json"}).header("sessionToken", (Object)this.getSessionToken()).post(null);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error, retry logout in 30 seconds", (Throwable)e);
            }
        }
    }
}

