/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.NoConfigException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.AppAuthResponse;
import model.PodCert;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.CertificateUtils;
import utils.HttpClientBuilderHelper;

public final class SymExtensionAppAuth
extends APIClient {
    private final Logger logger = LoggerFactory.getLogger(SymExtensionAppAuth.class);
    private SymConfig config;
    private Client sessionAuthClient;
    private int authRetries = 0;

    public SymExtensionAppAuth(SymConfig configuration) {
        this.config = configuration;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientAppBuilder(this.config);
        Client client = clientBuilder.build();
        if (StringUtils.isEmpty((CharSequence)this.config.getProxyURL())) {
            this.sessionAuthClient = client;
        } else {
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.property("jersey.config.client.proxy.uri", (Object)this.config.getProxyURL());
            if (!StringUtils.isEmpty((CharSequence)this.config.getProxyUsername()) && !StringUtils.isEmpty((CharSequence)this.config.getProxyPassword())) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)this.config.getProxyUsername());
                clientConfig.property("jersey.config.client.proxy.password", (Object)this.config.getProxyPassword());
            }
            this.sessionAuthClient = clientBuilder.withConfig((Configuration)clientConfig).build();
        }
    }

    public SymExtensionAppAuth(SymConfig configuration, ClientConfig sessionAuthClientConfig) {
        this.config = configuration;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientAppBuilder(this.config);
        this.sessionAuthClient = sessionAuthClientConfig != null ? clientBuilder.withConfig((Configuration)sessionAuthClientConfig).build() : clientBuilder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AppAuthResponse sessionAppAuthenticate(String appToken) {
        if (this.config == null) throw new NoConfigException("Must provide a SymConfig object to authenticate");
        this.logger.info("Session extension app auth");
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("appToken", appToken);
        Response response = this.sessionAuthClient.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/sessionauth/v1/authenticate/extensionApp").request(new String[]{"application/json"}).post(Entity.entity(input, (String)"application/json"));
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) return (AppAuthResponse)response.readEntity(AppAuthResponse.class);
        try {
            this.handleError(response, null);
        }
        catch (Exception e) {
            this.logger.error("Unexpected error, retry authentication in 30 seconds");
        }
        try {
            TimeUnit.SECONDS.sleep(30L);
        }
        catch (InterruptedException e) {
            this.logger.error("Error with authentication", (Throwable)e);
        }
        if (this.authRetries++ > 5) {
            this.logger.error("Max retries reached. Giving up on auth.");
            return null;
        }
        this.sessionAppAuthenticate(appToken);
        return null;
    }

    public AppAuthResponse sessionAppAuthenticate(String appToken, String podSessionAuthUrl) {
        this.logger.info("Session extension app auth");
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("appToken", appToken);
        Response response = this.sessionAuthClient.target("https://" + podSessionAuthUrl).path("/sessionauth/v1/authenticate/extensionApp").request(new String[]{"application/json"}).post(Entity.entity(input, (String)"application/json"));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error, retry authentication in 30 seconds");
            }
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException e) {
                this.logger.error("Error with authentication", (Throwable)e);
            }
            if (this.authRetries++ > 5) {
                this.logger.error("Max retries reached. Giving up on auth.");
                return null;
            }
        } else {
            return (AppAuthResponse)response.readEntity(AppAuthResponse.class);
        }
        this.sessionAppAuthenticate(appToken, podSessionAuthUrl);
        return null;
    }

    public Object verifyJWT(String jwt, String podSessionAuthUrl) {
        Response response;
        String authUrl = podSessionAuthUrl;
        if (StringUtils.isBlank((CharSequence)authUrl)) {
            authUrl = this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort();
        }
        if ((response = this.sessionAuthClient.target("https://" + authUrl).path("/sessionauth/v1/app/pod/certificate").request(new String[]{"application/json"}).get()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            try {
                this.handleError(response, null);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error, retry authentication in 30 seconds");
            }
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException e) {
                this.logger.error("Error with verify", (Throwable)e);
            }
            this.verifyJWT(jwt, podSessionAuthUrl);
        } else {
            PodCert cert = (PodCert)response.readEntity(PodCert.class);
            try {
                X509Certificate x509Certificate = CertificateUtils.parseX509Certificate(cert.getCertificate());
                PublicKey publicKey = x509Certificate.getPublicKey();
                JwtConsumer jwtConsumer = new JwtConsumerBuilder().setVerificationKey((Key)publicKey).setSkipAllValidators().build();
                JwtClaims jwtDecoded = jwtConsumer.processToClaims(jwt);
                return jwtDecoded.getClaimValue("user");
            }
            catch (GeneralSecurityException | InvalidJwtException e) {
                this.logger.error("Error with decoding jwt", e);
            }
        }
        return null;
    }
}

