/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.AuthEndpointConstants;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.NoConfigException;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.AppAuthResponse;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.HttpClientBuilderHelper;
import utils.JwtHelper;

public final class SymExtensionAppRSAAuth
extends APIClient {
    private final SecureRandom secureRandom = new SecureRandom();
    private final Logger logger = LoggerFactory.getLogger(SymExtensionAppRSAAuth.class);
    private SymConfig config;
    private Client sessionAuthClient;
    private String jwt;
    private int authRetries = 0;

    public SymExtensionAppRSAAuth(SymConfig configuration) {
        this.config = configuration;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(this.config);
        Client client = clientBuilder.build();
        if (StringUtils.isEmpty((CharSequence)this.config.getProxyURL())) {
            this.sessionAuthClient = client;
        } else {
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            clientConfig.property("jersey.config.client.proxy.uri", (Object)this.config.getProxyURL());
            if (!StringUtils.isEmpty((CharSequence)this.config.getProxyUsername()) && !StringUtils.isEmpty((CharSequence)this.config.getProxyPassword())) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)this.config.getProxyUsername());
                clientConfig.property("jersey.config.client.proxy.password", (Object)this.config.getProxyPassword());
            }
            this.sessionAuthClient = clientBuilder.withConfig((Configuration)clientConfig).build();
        }
    }

    public SymExtensionAppRSAAuth(SymConfig config, ClientConfig sessionAuthClientConfig, ClientConfig kmAuthClientConfig) {
        this.config = config;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config);
        this.sessionAuthClient = sessionAuthClientConfig != null ? clientBuilder.withConfig((Configuration)sessionAuthClientConfig).build() : clientBuilder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AppAuthResponse appAuthenticate() {
        PrivateKey privateKey = this.getPrivateKey();
        if (this.config == null) throw new NoConfigException("Must provide a SymConfig object to authenticate");
        this.logger.info("RSA extension app auth");
        this.jwt = JwtHelper.createSignedJwt(this.config.getAppId(), AuthEndpointConstants.JWT_EXPIRY_MS, privateKey);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("appToken", this.generateToken());
        token.put("authToken", this.jwt);
        Response response = this.sessionAuthClient.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/login/v1/pubkey/app/authenticate/extensionApp").request(new String[]{"application/json"}).post(Entity.entity(token, (String)"application/json"));
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) return (AppAuthResponse)response.readEntity(AppAuthResponse.class);
        try {
            this.handleError(response, null);
        }
        catch (Exception e) {
            this.logger.error("Unexpected error, retry authentication in 30 seconds");
        }
        try {
            TimeUnit.SECONDS.sleep(30L);
        }
        catch (InterruptedException e) {
            this.logger.error("Error with authentication", (Throwable)e);
        }
        if (this.authRetries++ > 5) {
            this.logger.error("Max retries reached. Giving up on auth.");
            return null;
        }
        this.appAuthenticate();
        return null;
    }

    private PrivateKey getPrivateKey() {
        PrivateKey privateKey = null;
        try {
            privateKey = JwtHelper.parseRSAPrivateKey(new File(this.config.getAppPrivateKeyPath() + this.config.getAppPrivateKeyName()));
        }
        catch (IOException | GeneralSecurityException e) {
            this.logger.error(e.getMessage());
        }
        return privateKey;
    }

    public String generateToken() {
        byte[] randBytes = new byte[64];
        this.secureRandom.nextBytes(randBytes);
        return Hex.encodeHexString((byte[])randBytes);
    }
}

