/*
 * Decompiled with CFR 0.152.
 */
package authentication;

import authentication.AuthEndpointConstants;
import authentication.ISymOBOAuth;
import authentication.SymOBOUserRSAAuth;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.NoConfigException;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import model.Token;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.HttpClientBuilderHelper;
import utils.JwtHelper;

public final class SymOBORSAAuth
extends APIClient
implements ISymOBOAuth {
    private final Logger logger = LoggerFactory.getLogger(SymOBORSAAuth.class);
    private String sessionToken;
    private SymConfig config;
    private Client sessionAuthClient;
    private long lastAuthTime = 0L;
    private String jwt;
    private int authRetries = 0;

    public SymOBORSAAuth(SymConfig configuration) {
        this.logger.info("SymOBOAuth being constructed");
        this.config = configuration;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(this.config);
        Client client = clientBuilder.build();
        if (StringUtils.isEmpty((CharSequence)this.config.getProxyURL()) && StringUtils.isEmpty((CharSequence)this.config.getPodProxyURL())) {
            this.sessionAuthClient = client;
        } else {
            String proxyURL = !StringUtils.isEmpty((CharSequence)this.config.getPodProxyURL()) ? this.config.getPodProxyURL() : this.config.getProxyURL();
            String proxyUser = !StringUtils.isEmpty((CharSequence)this.config.getPodProxyUsername()) ? this.config.getPodProxyUsername() : this.config.getProxyUsername();
            String proxyPass = !StringUtils.isEmpty((CharSequence)this.config.getPodProxyPassword()) ? this.config.getPodProxyPassword() : this.config.getProxyPassword();
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            clientConfig.property("jersey.config.client.proxy.uri", (Object)proxyURL);
            if (!StringUtils.isEmpty((CharSequence)proxyUser) && !StringUtils.isEmpty((CharSequence)proxyPass)) {
                clientConfig.property("jersey.config.client.proxy.username", (Object)proxyUser);
                clientConfig.property("jersey.config.client.proxy.password", (Object)proxyPass);
            }
            this.sessionAuthClient = clientBuilder.withConfig((Configuration)clientConfig).build();
        }
    }

    public SymOBORSAAuth(SymConfig configuration, ClientConfig sessionAuthClientConfig) {
        this.logger.info("SymOBORSAAuth being constructed with ClientConfig variable");
        this.config = configuration;
        ClientBuilder clientBuilder = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(this.config);
        this.sessionAuthClient = sessionAuthClientConfig != null ? clientBuilder.withConfig((Configuration)sessionAuthClientConfig).build() : clientBuilder.build();
    }

    @Override
    public SymOBOUserRSAAuth getUserAuth(String username) {
        SymOBOUserRSAAuth userAuth = new SymOBOUserRSAAuth(this.config, this.sessionAuthClient, username, (ISymOBOAuth)this);
        userAuth.authenticate();
        return userAuth;
    }

    @Override
    public SymOBOUserRSAAuth getUserAuth(Long uid) {
        SymOBOUserRSAAuth userAuth = new SymOBOUserRSAAuth(this.config, this.sessionAuthClient, uid, (ISymOBOAuth)this);
        userAuth.authenticate();
        return userAuth;
    }

    public void authenticate() {
        PrivateKey privateKey = null;
        try {
            privateKey = JwtHelper.parseRSAPrivateKey(new File(this.config.getAppPrivateKeyPath() + this.config.getAppPrivateKeyName()));
        }
        catch (IOException | GeneralSecurityException e) {
            this.logger.error("Error trying to parse RSA private key", (Throwable)e);
        }
        if (this.lastAuthTime == 0L | System.currentTimeMillis() - this.lastAuthTime > 3000L) {
            this.logger.info("Last auth time was {}", (Object)this.lastAuthTime);
            this.logger.info("Now is {}", (Object)System.currentTimeMillis());
            this.jwt = JwtHelper.createSignedJwt(this.config.getAppId(), AuthEndpointConstants.JWT_EXPIRY_MS, privateKey);
            this.sessionAppAuthenticate();
            this.lastAuthTime = System.currentTimeMillis();
        } else {
            try {
                this.logger.info("Re-authenticated too fast. Wait 30 seconds to try again.");
                TimeUnit.SECONDS.sleep(30L);
                this.authenticate();
            }
            catch (InterruptedException e) {
                this.logger.error("Error with authentication", (Throwable)e);
            }
        }
    }

    @Override
    public void sessionAppAuthenticate() {
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("token", this.jwt);
        if (this.config != null) {
            this.logger.info("Session app auth");
            Response response = this.sessionAuthClient.target("https://" + this.config.getSessionAuthHost() + ":" + this.config.getSessionAuthPort()).path("/login/pubkey/app/authenticate").request(new String[]{"application/json"}).post(Entity.entity(token, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, null);
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error, retry authentication in 30 seconds");
                }
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException e) {
                    this.logger.error("Error with session app authentication", (Throwable)e);
                }
                if (this.authRetries++ > 5) {
                    this.logger.error("Max retries reached. Giving up on auth.");
                    return;
                }
                this.sessionAppAuthenticate();
            } else {
                Token sessionTokenResponseContent = (Token)response.readEntity(Token.class);
                this.sessionToken = sessionTokenResponseContent.getToken();
            }
        } else {
            throw new NoConfigException("Must provide a SymConfig object to authenticate");
        }
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }
}

