/*
 * Decompiled with CFR 0.152.
 */
package clients;

import authentication.ISymAuth;
import clients.ISymClient;
import clients.symphony.api.AdminClient;
import clients.symphony.api.ConnectionsClient;
import clients.symphony.api.DatafeedClient;
import clients.symphony.api.FirehoseClient;
import clients.symphony.api.MessagesClient;
import clients.symphony.api.PresenceClient;
import clients.symphony.api.SignalsClient;
import clients.symphony.api.StreamsClient;
import clients.symphony.api.UsersClient;
import configuration.SymConfig;
import exceptions.SymClientException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import model.UserInfo;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import services.DatafeedEventsService;
import services.FirehoseService;
import utils.HttpClientBuilderHelper;
import utils.SymMessageParser;

public final class SymBotClient
implements ISymClient {
    private final Logger logger = LoggerFactory.getLogger(SymBotClient.class);
    private static SymBotClient botClient;
    private SymConfig config;
    private ISymAuth symBotAuth;
    private DatafeedClient datafeedClient;
    private MessagesClient messagesClient;
    private PresenceClient presenceClient;
    private StreamsClient streamsClient;
    private UsersClient usersClient;
    private ConnectionsClient connectionsClient;
    private DatafeedEventsService datafeedEventsService;
    private SignalsClient signalsClient;
    private UserInfo botUserInfo;
    private Client podClient;
    private Client agentClient;
    private AdminClient adminClient;
    private FirehoseClient firehoseClient;
    private FirehoseService firehoseService;

    public static SymBotClient initBot(SymConfig configuration, ISymAuth symBotAuthImp) {
        if (botClient == null) {
            botClient = new SymBotClient(configuration, symBotAuthImp);
            return botClient;
        }
        return botClient;
    }

    private SymBotClient(SymConfig configuration, ISymAuth symBotAuthImp, ClientConfig podClientConfig, ClientConfig agentClientConfig) {
        this.config = configuration;
        this.symBotAuth = symBotAuthImp;
        this.podClient = ClientBuilder.newClient((Configuration)podClientConfig);
        this.agentClient = ClientBuilder.newClient((Configuration)agentClientConfig);
        try {
            this.botUserInfo = this.getUsersClient().getSessionUser();
        }
        catch (SymClientException e) {
            this.logger.error("Error getting sessionUser ", (Throwable)e);
        }
        SymMessageParser.createInstance(this);
    }

    private SymBotClient(SymConfig config, ISymAuth symBotAuth) {
        this.config = config;
        this.symBotAuth = symBotAuth;
        String proxyURL = !StringUtils.isEmpty((CharSequence)config.getPodProxyURL()) ? config.getPodProxyURL() : config.getProxyURL();
        String proxyUser = !StringUtils.isEmpty((CharSequence)config.getPodProxyUsername()) ? config.getPodProxyUsername() : config.getProxyUsername();
        String proxyPass = !StringUtils.isEmpty((CharSequence)config.getPodProxyPassword()) ? config.getPodProxyPassword() : config.getProxyPassword();
        ClientConfig proxyConfig = new ClientConfig();
        proxyConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        proxyConfig.property("jersey.config.client.proxy.uri", (Object)proxyURL);
        if (!StringUtils.isEmpty((CharSequence)proxyUser) && !StringUtils.isEmpty((CharSequence)proxyPass)) {
            proxyConfig.property("jersey.config.client.proxy.username", (Object)proxyUser);
            proxyConfig.property("jersey.config.client.proxy.password", (Object)proxyPass);
        }
        this.agentClient = StringUtils.isEmpty((CharSequence)config.getProxyURL()) ? HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build() : HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)proxyConfig).build();
        this.podClient = StringUtils.isEmpty((CharSequence)config.getPodProxyURL()) && StringUtils.isEmpty((CharSequence)config.getProxyURL()) ? HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build() : HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)proxyConfig).build();
        try {
            this.botUserInfo = this.getUsersClient().getSessionUser();
        }
        catch (SymClientException e) {
            this.logger.error("Error getting sessionUser ", (Throwable)e);
        }
        SymMessageParser.createInstance(this);
    }

    public static SymBotClient initBot(SymConfig config, ISymAuth botAuth, ClientConfig podClientConfig, ClientConfig agentClientConfig) {
        if (botClient == null) {
            botClient = new SymBotClient(config, botAuth, podClientConfig, agentClientConfig);
            return botClient;
        }
        return botClient;
    }

    public UserInfo getBotUserInfo() {
        return this.botUserInfo;
    }

    public DatafeedClient getDatafeedClient() {
        if (this.datafeedClient == null) {
            this.datafeedClient = new DatafeedClient(this);
        }
        return this.datafeedClient;
    }

    public FirehoseClient getFirehoseClient() {
        if (this.firehoseClient == null) {
            this.firehoseClient = new FirehoseClient(this);
        }
        return this.firehoseClient;
    }

    public FirehoseService getFirehoseService() {
        if (this.firehoseService == null) {
            this.firehoseService = new FirehoseService(this);
        }
        return this.firehoseService;
    }

    @Override
    public SymConfig getConfig() {
        return this.config;
    }

    @Override
    public ISymAuth getSymAuth() {
        return this.symBotAuth;
    }

    @Override
    public MessagesClient getMessagesClient() {
        if (this.messagesClient == null) {
            SymMessageParser.createInstance(this);
            this.messagesClient = new MessagesClient(this);
        }
        return this.messagesClient;
    }

    @Override
    public PresenceClient getPresenceClient() {
        if (this.presenceClient == null) {
            this.presenceClient = new PresenceClient(this);
        }
        return this.presenceClient;
    }

    @Override
    public StreamsClient getStreamsClient() {
        if (this.streamsClient == null) {
            this.streamsClient = new StreamsClient(this);
        }
        return this.streamsClient;
    }

    @Override
    public UsersClient getUsersClient() {
        if (this.usersClient == null) {
            this.usersClient = new UsersClient(this);
        }
        return this.usersClient;
    }

    @Override
    public ConnectionsClient getConnectionsClient() {
        if (this.connectionsClient == null) {
            this.connectionsClient = new ConnectionsClient(this);
        }
        return this.connectionsClient;
    }

    public DatafeedEventsService getDatafeedEventsService() {
        if (this.datafeedEventsService == null) {
            this.datafeedEventsService = new DatafeedEventsService(this);
        }
        return this.datafeedEventsService;
    }

    @Override
    public SignalsClient getSignalsClient() {
        if (this.signalsClient == null) {
            this.signalsClient = new SignalsClient(this);
        }
        return this.signalsClient;
    }

    public AdminClient getAdminClient() {
        if (this.adminClient == null) {
            this.adminClient = new AdminClient(this);
        }
        return this.adminClient;
    }

    public void clearBotClient() {
        botClient = null;
    }

    public static SymBotClient getBotClient() {
        return botClient;
    }

    @Override
    public Client getPodClient() {
        return this.podClient;
    }

    @Override
    public Client getAgentClient() {
        return this.agentClient;
    }

    @Override
    public void setPodClient(Client podClient) {
        this.podClient = podClient;
    }

    @Override
    public void setAgentClient(Client agentClient) {
        this.agentClient = agentClient;
    }
}

